% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_fys_permitted.R
\name{validate_fys_permitted}
\alias{validate_fys_permitted}
\title{Verifying validity of financial years}
\usage{
validate_fys_permitted(to_verify, permitted_fys, min.yr = NULL,
  max.yr = NULL, deparsed = deparse(substitute(to_verify)),
  allow.projection = TRUE,
  earliest_permitted_financial_year = "earliest permitted financial year",
  latest_permitted_financial_year = "latest permitted financial year")
}
\arguments{
\item{to_verify}{A user-provided value, purporting to be
character vector of financial years.}

\item{permitted_fys}{A character vector of valid financial years.}

\item{min.yr, max.yr}{Integers specifying the range of \code{to_verify}.
If \code{NULL}, no restriction on the upper or lower bound of the range.}

\item{deparsed}{A string indicating the argument that the user provided.
Should generally be provided explicitly as the default is unlikely 
to be user-friendly.}

\item{allow.projection}{If \code{FALSE} emit a different error message.}

\item{earliest_permitted_financial_year, latest_permitted_financial_year}{Text
for earliest/latest permitted financial year when \code{min.yr}/\code{max.yr}
condition is violated.}
}
\value{
If \code{to_verify} contains valid financial years
they are returned all in the form \code{2013-14}. If they were
already in that form, they obtain the following attributes:
\describe{
\item{\code{grattan_all_fy}}{\code{TRUE} if all the financial years are valid.}
\item{\code{grattan_min_yr}}{An integer, the earliest year ending in \code{to_verify}.}
\item{\code{grattan_max_yr}}{An integer, the latest year ending in \code{to_verify}.}
}
}
\description{
Many functions expect financial years. 
Determining that they are validly entered is often quite 
computationally costly, relative to the core calculations.
These internal functions provide mechanisms to check validity
quickly, while still providing clear, accurate error messages.
}
