% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Greeks.R
\name{Greeks}
\alias{Greeks}
\title{Computes the Greeks of various options in the Black Scholes model or both in
the Black Scholes model or a Jump Diffusion model in the case of Asian
Options, or in the Binomial options pricing model}
\usage{
Greeks(
  initial_price,
  exercise_price,
  r,
  time_to_maturity,
  volatility,
  dividend_yield = 0,
  model = "Black_Scholes",
  option_type = "European",
  payoff = "call",
  greek = c("fair_value", "delta", "vega", "theta", "rho", "gamma"),
  antithetic = TRUE,
  ...
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset
}}

\item{exercise_price}{\itemize{
\item strike price of the option
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{model}{\itemize{
\item the model to be chosen in ("black_scholes", "jump_diffusion")
}}

\item{option_type}{in c("European", "American", "Asian", "Geometric Asian",
"Digital", "Binomial) - the type of option to be considered}

\item{payoff}{\itemize{
\item in c("call", "put", "cash_or_nothing_call",
"cash_or_nothing_put", "asset_or_nothing_call", "asset_or_nothing_put")
}}

\item{greek}{\itemize{
\item Greeks to be calculated in c("fair_value", "delta", "vega",
"theta", "rho", "epsilon", "lambda", "gamma", "vanna", "charm", "vomma",
"veta", "vera", "speed", "zomma", "color", "ultima")
}}

\item{antithetic}{\itemize{
\item if TRUE, antithetic random numbers will be chosen to
decrease variance
}}

\item{...}{\itemize{
\item ...    Other arguments passed on to methods
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
Computes the Greeks of various options in the Black Scholes model or both in
the Black Scholes model or a Jump Diffusion model in the case of Asian
Options, or in the Binomial options pricing model
}
\examples{
Greeks(initial_price = 100, exercise_price = 120, r = 0.01,
time_to_maturity = 5, volatility = 0.30, payoff = "call")

Greeks(initial_price = 100, exercise_price = 100, r = -0.005,
time_to_maturity = 1, volatility = 0.30, payoff = "put",
option_type = "American")
}
