% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_accessibility_visualizations.R
\name{create_accessibility_visualizations}
\alias{create_accessibility_visualizations}
\title{Create Green Space Accessibility Visualizations}
\usage{
create_accessibility_visualizations(
  accessibility_analysis,
  green_areas,
  mode = "walking"
)
}
\arguments{
\item{accessibility_analysis}{Output from \code{analyze_green_accessibility()}.}

\item{green_areas}{An \code{sf} object of green areas (e.g., OSM polygons).}

\item{mode}{Character. Mode to plot (for multi-mode results).}
}
\value{
A list with:
\describe{
\item{distance_map}{ggplot map of grid distance to green space.}
\item{coverage_plot}{Barplot of spatial and/or population-weighted coverage.}
\item{directional_plot}{Radar plot for directional coverage (with y-axis/radius labels inside at N).}
\item{combined_plot}{Patchwork combination of all static plots.}
\item{leaflet_map}{Interactive leaflet map with overlays.}
\item{summary}{Character summary of statistics.}
\item{directional_table}{Table of directional mean coverage values.}
\item{data}{Underlying data used for plotting.}
}
}
\description{
Generates static and interactive visualizations for green space accessibility,
including distance maps, coverage plots (spatial and population-weighted), and a radar plot
with inside y-axis tick labels. Provides an interactive leaflet map with base and overlay controls.
}
\examples{
\dontrun{
result <- analyze_green_accessibility(
  network_data = data$highways$osm_lines,
  green_areas = data$green_areas$osm_polygons,
  mode = "walking",
  grid_size = 300,
  population_raster = pop_raster_raw
)
viz <- create_accessibility_visualizations(result, data$green_areas$osm_polygons, mode = "walking")
print(viz$distance_map)
print(viz$coverage_plot)
print(viz$directional_plot)
print(viz$combined_plot)
viz$leaflet_map  # View in RStudio Viewer
cat(viz$summary)
print(viz$directional_table)
}
}
