% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gremlin.R, R/mkModMats.R
\name{gremlinR}
\alias{gremlinR}
\alias{gremlin}
\alias{mkModMats}
\title{Mixed-effect modeling functions.}
\usage{
gremlinR(formula, random = NULL, rcov = ~units, data = NULL,
  ginverse = NULL, Gstart = NULL, Rstart = NULL, Bp = NULL,
  maxit = 20, algit = NULL, vit = 10, v = 1, ...)

mkModMats(formula, random = NULL, rcov = ~units, data = NULL,
  subset = NULL, ginverse = NULL, na.action = na.pass,
  offset = NULL, contrasts = NULL, Xsparse = TRUE, ...)
}
\arguments{
\item{formula}{A \code{formula} for the response variable and fixed effects.}

\item{random}{A \code{formula} for the random effects.}

\item{rcov}{A \code{formula} for the residual covariance structure.}

\item{data}{A \code{data.frame} in which to look for the terms in
\code{formula}, \code{random}, and \code{rcov}.}

\item{ginverse}{A \code{list} of (preferably sparse) inverse matrices that
are proportional to the covariance structure of the random effects.
The name of each element in the list should match a column in \code{data}
that is associated with a random term. All levels of the random term should
appear as \code{rownames} for the matrices.}

\item{Gstart}{A \code{list} of starting (co)variance values for the the
G-structure or random terms.}

\item{Rstart}{A \code{list} of starting (co)variance values for the
R-structure or residual terms.}

\item{Bp}{A prior specification for fixed effects.}

\item{maxit}{An \code{integer} specifying the maximum number of likelihood
iterations.}

\item{algit}{A \code{character} vector of length 1 or more or an expression
to be evaluated that specifies the algorithm to use for proposing
(co)variances in the next likelihood iteration.}

\item{vit}{An \code{integer} value specifying the verbosity of screen output
on each iteration. A value of zero gives no iteration specific output and
larger values increase the amount of information printed on the screen.}

\item{v}{An \code{integer} value specifying the verbosity of screen output
regarding the model fitting process. A value of zero gives no details and
larger values increase the amount of information printed on the screen.}

\item{\dots}{Additional arguments to be passed to control the model fitting.}

\item{subset}{An expression for the subset of \code{data} to use.}

\item{na.action}{What to do with NAs.}

\item{offset}{Should an offset be specified.}

\item{contrasts}{Specify the type of contrasts for the fixed effects.}

\item{Xsparse}{Should sparse matrices be used for the fixed effects design
matrix.}
}
\value{
A \code{list} of class \code{gremlin} or \code{gremlinModMats}:
  \describe{
    \item{call }{The model \code{call}.}
    \item{modMats }{A \code{list} of the model matrices used to construct the
      mixed model equations.}
      \item{y }{The response vector.}
      \item{ny }{The number of responses.}
      \item{ncy }{The number of columns of the original response.}
      \item{X }{ The fixed effects design matrix.}
      \item{nb }{The number of columns in X.}
      \item{Zr }{The residual design matrix.}
      \item{Zg }{A list of the design matrices for each random term.}
      \item{nG }{The number of parameters in the G structure.}
      \item{listGeninv }{A list of generalized inverse matrices.}
      \item{logDetG }{The log-determinants of the generalized inverse 
      matrices - necessary to calculate the log-likelihood.}

    \item{itMat }{A \code{matrix} of details about each iteration.}
    \item{sln }{A two column \code{matrix} of solutions and their sampling
      variances from the mixed model.}
    \item{residuals }{A \code{vector} of residual deviations, response minus
      the values expected based on the solutions, corresponding to the order
      in \code{modMats$y}.} 
    \item{theta }{A \code{matrix} of (co)variance components at the last
      iteration.}
    \item{AI }{A \code{matrix} of values containing the Average Information
      matrix, or second partial derivatives of the likelihood with respect to
      the (co)variance components. The inverse of this matrix gives the
      sampling variances of the (co)variance components.}
    \item{dLdtheta }{A single column \code{matrix} of first derivatives of
      the (co)variance parameters with respect to the log-Likelihood.}
  }
}
\description{
Create and fit linear mixed-effect model (Gaussian data) or checking if an
object is a fitted model.
}
\section{Functions}{
\itemize{
\item \code{mkModMats}: Generates model matrices.
}}

\examples{
  library(nadiv)
  Ainv <- makeAinv(Mrode3[-c(1:2), 1:3])$Ainv
  mod11 <- gremlinR(WWG11 ~ sex - 1,
  	random = ~ calf,
  	data = Mrode11,
  	ginverse = list(calf = Ainv),
  	Gstart = matrix(0.2), Rstart = matrix(0.4),
  	maxit = 10, v = 2)

  is(mod11)
}
\references{
Henderson
Mrode. 2005.
}
\author{
\email{matthewwolak@gmail.com}
}
