% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dReport.r
\name{dReport}
\alias{dReport}
\title{Descriptive Statistics Report}
\usage{
dReport(
  formula,
  groups = NULL,
  what = c("box", "proportions", "xy", "byx"),
  byx.type = c("violin", "quantiles"),
  violinbox = TRUE,
  violinbox.opts = list(col = adjustcolor("blue", alpha.f = 0.25), border = FALSE),
  summaryPsort = FALSE,
  exclude1 = TRUE,
  stable = TRUE,
  fun = NULL,
  data = NULL,
  subset = NULL,
  na.action = na.retain,
  panel = "desc",
  subpanel = NULL,
  head = NULL,
  tail = NULL,
  continuous = 10,
  h = 5.5,
  w = 5.5,
  outerlabels = TRUE,
  append = FALSE,
  sopts = NULL,
  popts = NULL,
  lattice = FALSE
)
}
\arguments{
\item{formula}{a formula accepted by the \code{bpplotM} or \code{summaryP} functions.  \code{formula} must have an \code{id(subjectidvariable)} term if there are repeated measures, in order to get correct subject counts as \code{nobs}.}

\item{groups}{a superpositioning variable, usually treatment, for categorical charts.  For continuous analysis variables, \code{groups} becomes the \code{y}-axis stratification variable.  This is a single character string.}

\item{what}{\code{"box"} (the default) or \code{"xy"} for continuous analysis variables, or \code{"proportions"} (or shorter) for categorical ones.  Instead, specifying \code{what="byx"} results in an array of quantile intervals for continuous \code{y}, Wilson confidence intervals for proportions when \code{y} is binary, or means and parametric confidence limits when \code{y} is not continuous but is not binary.  If \code{what} is omitted or \code{what="byx"}, actions will be inferred from the most continuous variable listed in \code{formula}.  When \code{fun} is given, different behavior results (see below).}

\item{byx.type}{set to \code{"quantiles"} to show vertical quantile intervals of \code{y} at each \code{x} for when \code{what="byx"} and the \code{y} variable is continuous numeric, or set \code{byx.type="violin"} (the default) to plot half-violin plots at each \code{x}.}

\item{violinbox}{set to \code{TRUE} to add violin plots to box plots}

\item{violinbox.opts}{a list to pass to \code{panel.violin}}

\item{summaryPsort}{set to \code{TRUE} to sort categories in descending order of frequencies}

\item{exclude1}{logical used for \code{latex} methods when \code{summaryM} or \code{summaryP} are called by \code{dReport}, or for plot methods for \code{summaryP}.  The default is \code{TRUE} to cause the most frequent level of any two-level categorical variable to not be used as a separate category in the graphic or table.  See \code{\link[Hmisc]{summaryM}}.}

\item{stable}{set to \code{FALSE} to suppress creation of backup supplemental tables for graphics}

\item{fun}{a function that takes individual response variables (which may be matrices, as in \code{\link[survival]{Surv}} objects) and creates one or more summary statistics that will be computed while the resulting data frame is being collapsed to one row per condition.  Dot charts are drawn when \code{fun} is given.}

\item{data}{data frame}

\item{subset}{a subsetting epression for the entire analysis}

\item{na.action}{a NA handling function for data frames, default is \code{na.retain}}

\item{panel}{character string.  Name of panel, which goes into file base names and figure labels for cross-referencing}

\item{subpanel}{If calling \code{dReport} more than once for the same type of chart (by different values of \code{what}), specify \code{subpanel} to distinguish the multiple calls.  In that case, \code{-subpanel} will be appended to \code{panel} when creating figure labels and cross-references.}

\item{head}{character string.  Specifies initial text in the figure caption, otherwise a default is used}

\item{tail}{optional character string.  Specifies final text in the figure caption, e.g., what might have been put in a footnote in an ordinary text page.  This appears just before any needles.}

\item{continuous}{the minimum number of numeric values a variable must have in order to be considered continuous.  Also passed to \code{summaryM}.}

\item{h}{numeric.  Height of plot, in inches}

\item{w}{numeric.  Width of plot}

\item{outerlabels}{logical that if \code{TRUE}, pass \code{lattice} graphics through the \code{latticeExtra} package's \code{useOuterStrips}function if there are two conditioning (paneling) variables, to put panel labels in outer margins.}

\item{append}{logical.  Set to \code{FALSE} to start a new panel}

\item{sopts}{list specifying extra arguments to pass to \code{bpplotM}, \code{summaryP}, or \code{summaryS}}

\item{popts}{list specifying extra arguments to pass to a plot method.  One example is \code{text.at} to specify some number beyond \code{xlim[2]} to leave extra space for numerators and denominators when using \code{summaryP} for categorical analysis variables.  Another common use is for example \code{popts=list(layout=c(columns,rows))} to be used in rendering \code{lattice} plots.  \code{key} and \code{panel} are also frequently used.}

\item{lattice}{set to \code{TRUE} to use \code{lattice} instead of \code{ggplot2} for proportions.  When this option is in effect, numerators and denominators are shown.}
}
\description{
Generate graphics and LaTeX with descriptive statistics
}
\details{
\code{dReport} generates multi-panel charts, separately for categorical analysis variables and continuous ones.  The Hmisc \code{summaryP} function and its plot method are used for categorical variables, and \code{bpplotM} is used to make extended box plots for continuous ones unless \code{what='byx'}.   Stratification is by treatment or other variables.  The user must have defined a LaTeX macro \code{\\eboxpopup} (which may be defined to do nothing) with one argument.  This macro is called with argument \code{extended box plot} whenever that phrase appears in the legend, so that a \code{PDF} popup may be generated to show the prototype.  See the example in \code{report.Rnw} in the \code{tests} directory.  Similarly a popup macro \code{\\qintpopup} must be defined, which generates a tooltip for the phrase \code{quantile intervals}.
}
\examples{
# See test.Rnw in tests directory
}
