% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survReport.r
\name{survReport}
\alias{survReport}
\title{Survival Report}
\usage{
survReport(
  formula,
  data = NULL,
  subset = NULL,
  na.action = na.retain,
  ylab = NULL,
  what = c("S", "1-S"),
  conf = c("diffbands", "bands", "bars", "none"),
  cause = NULL,
  panel = "surv",
  subpanel = NULL,
  head = NULL,
  tail = NULL,
  h = 3,
  w = 4.5,
  multi = FALSE,
  markevent = TRUE,
  mfrow = NULL,
  y.n.risk = 0,
  mylim = NULL,
  bot = 2,
  aehaz = TRUE,
  times = NULL,
  append = FALSE,
  opts = NULL,
  ...
)
}
\arguments{
\item{formula}{a formula with survival (\code{Surv}) objects on the left hand side and an optional stratification factor on the right (or \code{1} if none).  The survival object component variables should be labeled; these labels are used for graph annotation.  If any of the \code{Surv} objects are competing risk objects (see \code{\link[survival]{Surv}}), event labels come from the factor levels in the variable that was the second argument to \code{Surv}, and the first factor level must correspond to right-censored observations.}

\item{data}{data.frame}

\item{subset}{optional subsetting criteria}

\item{na.action}{function for handling \code{NA}s while creating a data frame}

\item{ylab}{character. Passed to \code{\link[rms]{survplot.npsurv}} as the \code{ylab} argument.  Constructed by default.}

\item{what}{\code{"S"} (the default) to plot survival functions or \code{"1-S"} to plot cumulative incidence functions.  If any of the survival time objects on the left hand side are competing risk objects, the default is \code{"1-S"} and you may not change it.}

\item{conf}{character. See \code{\link[rms]{survplot.npsurv}}.}

\item{cause}{character vector or list.  If a vector, every \code{Surv} term on the left hand side of \code{formula} will have cumulative incidence plotted for all causes that appear in \code{cause}.  If a list, the list elements must correspond to the \code{Surv} terms in order, and specify which causes to display from the corresponding \code{Surv} object.  When \code{cause} is a list and one of its elements contains more than one character string, or when \code{cause} is a vector and for one \code{Surv} object it matches multiple causes, \code{survReport} produces more plots than there are \code{Surv} objects.}

\item{panel}{character string.  Name of panel, which goes into file base names and figure labels for cross-referencing.}

\item{subpanel}{character string.  If calling \code{dReport} more than once for the same type of chart (categorical or continuous), specify \code{subpanel} to distinguish the multiple calls.  In that case, \code{-subpanel} will be appended to \code{panel} when creating figure labels and cross-references.}

\item{head}{character string.  Specifies initial text in the figure caption, otherwise a default is used.}

\item{tail}{optional character string.  Specifies final text in the figure caption, e.g., what might have been put in a footnote in an ordinary text page.  This appears just before any needles.}

\item{h}{numeric. Height of plots.}

\item{w}{numeric. Width of plots in inches.}

\item{multi}{logical.  If \code{TRUE}, multiple figures are produced, otherwise a single figure with a matrix of survival plots is made.}

\item{markevent}{logical.  Applies only if \code{multi=TRUE}.  Specify \code{FALSE} to not put the event label in the extreme upper left of the plot.}

\item{mfrow}{numeric 2-vector, used if \code{multi=FALSE}.  If not specified, default plot matrix layout will be figured.}

\item{y.n.risk}{used if \code{what="1-S"}, to specify \code{y} coordinate for putting numbers at risk, typically below the \code{x}-axis label}

\item{mylim}{numeric 2-vector.  Used to force expansion of computed y-axis limits.  See \code{survplot}.}

\item{bot}{number of spaces to reserve at bottom of plot for numbers at risk, if \code{what="1-S"}}

\item{aehaz}{logical.  Set to \code{FALSE} to not print number of events and hazard rate on plots.}

\item{times}{numeric vector.  If specified, prints cumulative incidence probabilities at those times on the plots.}

\item{append}{logical. If \code{TRUE} output will be appended instead of overwritten.}

\item{opts}{list.  A list specifying arguments to \code{survReport} and \code{startPlot} that override any other arguments.  This is useful when making a long series of \code{survReport} calls with the same options, as the options can be defined up front in a list.}

\item{\dots}{ignored}
}
\description{
Generate a Survival Report with Kaplan-Meier Estimates
}
\examples{
## See tests directory test.Rnw for a live example
\dontrun{
  set.seed(1)
  n <- 400
  dat <- data.frame(t1=runif(n, 2, 5), t2=runif(n, 2, 5),
                    e1=rbinom(n, 1, .5), e2=rbinom(n, 1, .5),
                    treat=sample(c('a','b'), n, TRUE))
  dat <- upData(dat,
                labels=c(t1='Time to operation',
                         t2='Time to rehospitalization',
                         e1='Operation', e2='Hospitalization',
                         treat='Treatment')
                units=c(t1='year', t2='year'))
  survReport(Surv(t1, e1) + Surv(t2, e2) ~ treat, data=dat)

  dat <- upData(dat, labels=c(t1='Follow-up Time', t2='Time'),
                cause=factor(sample(c('death','MI','censor'), n, TRUE),
                             c('censor', 'MI', 'death')))
  survReport(Surv(t1, cause) ~ treat, cause='death', data=dat)
  survReport(Surv(t1, cause) + Surv(t2, cause) ~ treat,
             cause=list(c('death', 'MI'), 'death'), data=dat)
  # Two plots for t1, one plot for t2
}
}
