% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{exponential_censored}
\alias{exponential_censored}
\title{Exponential Censored Distribution}
\usage{
exponential_censored(
  rate,
  is_censored,
  censor = "right",
  lower = NULL,
  upper = NULL,
  dim = length(is_censored)
)
}
\arguments{
\item{rate}{Rate parameter of the exponential distribution.}

\item{is_censored}{Logical vector indicating whether each observation is censored.}

\item{censor}{Type of censoring: one of 'right', 'left', 'interval'.}

\item{lower}{Lower bound for interval censoring (optional).}

\item{upper}{Upper bound for interval censoring (optional).}

\item{dim}{Dimension of the data (optional, defaults to length of \code{rate}).}
}
\value{
A greta censored exponential distribution node.
}
\description{
Creates a censored exponential distribution for use with greta.
}
