% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_distributions.R
\name{distributions}
\alias{distributions}
\alias{uniform}
\alias{normal}
\alias{lognormal}
\alias{bernoulli}
\alias{binomial}
\alias{beta_binomial}
\alias{negative_binomial}
\alias{hypergeometric}
\alias{poisson}
\alias{gamma}
\alias{inverse_gamma}
\alias{weibull}
\alias{exponential}
\alias{pareto}
\alias{student}
\alias{laplace}
\alias{beta}
\alias{cauchy}
\alias{chi_squared}
\alias{logistic}
\alias{f}
\alias{multivariate_normal}
\alias{wishart}
\alias{lkj_correlation}
\alias{multinomial}
\alias{categorical}
\alias{dirichlet}
\alias{dirichlet_multinomial}
\title{probability distributions}
\usage{
uniform(min, max, dim = NULL)

normal(mean, sd, dim = NULL, truncation = c(-Inf, Inf))

lognormal(meanlog, sdlog, dim = NULL, truncation = c(0, Inf))

bernoulli(prob, dim = NULL)

binomial(size, prob, dim = NULL)

beta_binomial(size, alpha, beta, dim = NULL)

negative_binomial(size, prob, dim = NULL)

hypergeometric(m, n, k, dim = NULL)

poisson(lambda, dim = NULL)

gamma(shape, rate, dim = NULL, truncation = c(0, Inf))

inverse_gamma(alpha, beta, dim = NULL, truncation = c(0, Inf))

weibull(shape, scale, dim = NULL, truncation = c(0, Inf))

exponential(rate, dim = NULL, truncation = c(0, Inf))

pareto(a, b, dim = NULL, truncation = c(0, Inf))

student(df, mu, sigma, dim = NULL, truncation = c(-Inf, Inf))

laplace(mu, sigma, dim = NULL, truncation = c(-Inf, Inf))

beta(shape1, shape2, dim = NULL, truncation = c(0, 1))

cauchy(location, scale, dim = NULL, truncation = c(-Inf, Inf))

chi_squared(df, dim = NULL, truncation = c(0, Inf))

logistic(location, scale, dim = NULL, truncation = c(-Inf, Inf))

f(df1, df2, dim = NULL, truncation = c(0, Inf))

multivariate_normal(mean, Sigma, dim = 1)

wishart(df, Sigma)

lkj_correlation(eta, dim = 2)

multinomial(size, prob, dim = 1)

categorical(prob, dim = 1)

dirichlet(alpha, dim = 1)

dirichlet_multinomial(size, alpha, dim = 1)
}
\arguments{
\item{min, max}{scalar values giving optional limits to \code{uniform}
variables. Like \code{lower} and \code{upper}, these must be specified as
numerics, they cannot be greta arrays (though see details for a
workaround). Unlike \code{lower} and \code{upper}, they must be finite.
\code{min} must always be less than \code{max}.}

\item{dim}{the dimensions of the greta array to be returned, either a scalar
or a vector of positive integers. See details.}

\item{mean, meanlog, location, mu}{unconstrained parameters}

\item{sd, sdlog, sigma, lambda, shape, rate, df, scale, shape1, shape2, alpha, beta, df1, df2, a, b, eta}{positive parameters, \code{alpha} must be a vector for \code{dirichlet} and \code{dirichlet_multinomial}.}

\item{truncation}{a length-two vector giving values between which to truncate
the distribution, similarly to the \code{lower} and \code{upper} arguments
to \code{\link{variable}}}

\item{prob}{probability parameter (\code{0 < prob < 1}), must be a vector for
\code{multinomial} and \code{categorical}}

\item{size, m, n, k}{positive integer parameter}

\item{Sigma}{positive definite variance-covariance matrix parameter}
}
\description{
These functions can be used to define random variables in a
  greta model. They return a variable greta array that follows the specified
  distribution. This variable greta array can be used to represent a
  parameter with  prior distribution, or used with \code{\link{distribution}}
  to define a distribution over a data greta array.
}
\details{
The discrete probability distributions (\code{bernoulli},
  \code{binomial}, \code{negative_binomial}, \code{poisson},
  \code{multinomial}, \code{categorical}, \code{dirichlet_multinomial}) can
  be used when they have fixed values (e.g. defined as a likelihood using
  \code{\link{distribution}}, but not as unknown variables.

  For univariate distributions \code{dim} gives the dimensions of the greta
  array to create. Each element of the greta array will be (independently)
  distributed according to the distribution. \code{dim} can also be left at
  its default of \code{NULL}, in which case the dimension will be detected
  from the dimensions of the parameters (provided they are compatible with
  one another).

  For \code{multivariate_normal()}, \code{multinomial()}, and
  \code{categorical()} \code{dim} must be a scalar giving the number of rows
  in the resulting greta array, each row being (independently) distributed
  according to the multivariate normal distribution. The number of columns
  will always be the dimension of the distribution, determined from the
  parameters specified. \code{wishart()} always returns a single square, 2D
  greta array, with dimension determined from the parameter \code{Sigma}.

  \code{multinomial()} does not check that observed values sum to
  \code{size}, and \code{categorical()} does not check that only one of the
  observed entries is 1. It's the user's responsibility to check their data
  matches the distribution!

  The parameters of \code{uniform} must be fixed, not greta arrays. This
  ensures these values can always be transformed to a continuous scale to run
  the samplers efficiently. However, a hierarchical \code{uniform} parameter
  can always be created by defining a \code{uniform} variable constrained
  between 0 and 1, and then transforming it to the required scale. See
  below for an example.

  Wherever possible, the parameterisation and argument names of greta
  distributions matches commonly used R functions for distributions, such as
  those in the \code{stats} or \code{extraDistr} packages. The following
  table states the distribution function to which greta's implementation
  corresponds:

  \tabular{ll}{ greta \tab reference\cr
   \code{uniform} \tab \link[stats:dunif]{stats::dunif}\cr
   \code{normal} \tab \link[stats:dnorm]{stats::dnorm}\cr
   \code{lognormal} \tab \link[stats:dlnorm]{stats::dlnorm}\cr
   \code{bernoulli} \tab \link[extraDistr:dbern]{extraDistr::dbern}\cr
   \code{binomial} \tab \link[stats:dbinom]{stats::dbinom}\cr
   \code{beta_binomial} \tab \link[extraDistr:dbbinom]{extraDistr::dbbinom}\cr
   \code{negative_binomial} \tab \link[stats:dnbinom]{stats::dnbinom}\cr
   \code{hypergeometric} \tab \link[stats:dhyper]{stats::dhyper}\cr
   \code{poisson} \tab \link[stats:dpois]{stats::dpois}\cr
   \code{gamma} \tab \link[stats:dgamma]{stats::dgamma}\cr
   \code{inverse_gamma} \tab \link[extraDistr:dinvgamma]{extraDistr::dinvgamma}\cr
   \code{weibull} \tab \link[stats:dweibull]{stats::dweibull}\cr
   \code{exponential} \tab \link[stats:dexp]{stats::dexp}\cr
   \code{pareto} \tab \link[extraDistr:dpareto]{extraDistr::dpareto}\cr
   \code{student} \tab \link[extraDistr:dnst]{extraDistr::dnst}\cr
   \code{laplace} \tab \link[extraDistr:dlaplace]{extraDistr::dlaplace}\cr
   \code{beta} \tab \link[stats:dbeta]{stats::dbeta}\cr
   \code{cauchy} \tab \link[stats:dcauchy]{stats::dcauchy}\cr
   \code{chi_squared} \tab \link[stats:dchisq]{stats::dchisq}\cr
   \code{logistic} \tab \link[stats:dlogis]{stats::dlogis}\cr
   \code{f} \tab \link[stats:df]{stats::df}\cr
   \code{multivariate_normal} \tab \link[mvtnorm:dmvnorm]{mvtnorm::dmvnorm}\cr
   \code{multinomial} \tab \link[stats:dmultinom]{stats::dmultinom}\cr
   \code{categorical} \tab {\link[stats:dmultinom]{stats::dmultinom} (size = 1)}\cr
   \code{dirichlet} \tab \link[extraDistr:ddirichlet]{extraDistr::ddirichlet}\cr
   \code{dirichlet_multinomial} \tab \link[extraDistr:ddirmnom]{extraDistr::ddirmnom}\cr
   \code{wishart} \tab \link[stats:rWishart]{stats::rWishart}\cr
   \code{lkj_correlation} \tab \href{https://rdrr.io/github/rmcelreath/rethinking/man/dlkjcorr.html}{rethinking::dlkjcorr}\cr }
}
\examples{
# a uniform parameter constrained to be between 0 and 1
phi = uniform(min = 0, max = 1)

# a length-three variable, with each element following a standard normal
# distribution
alpha = normal(0, 1, dim = 3)

# a length-three variable of lognormals
sigma = lognormal(0, 3, dim = 3)

# a hierarchical uniform, constrained between alpha and alpha + sigma,
eta = alpha + uniform(0, 1, dim = 3) * sigma

# a hierarchical distribution
mu = normal(0, 1)
sigma = lognormal(0, 1)
theta = normal(mu, sigma)

# a vector of 3 variables drawn from the same hierarchical distribution
thetas = normal(mu, sigma, dim = 3)

# a matrix of 12 variables drawn from the same hierarchical distribution
thetas = normal(mu, sigma, dim = c(3, 4))

# a multivariate normal variable, with correlation between two elements
Sig <- diag(4)
Sig[3, 4] <- Sig[4, 3] <- 0.6
theta = multivariate_normal(rep(mu, 4), Sig)

# 10 independent replicates of that
theta = multivariate_normal(rep(mu, 4), Sig, dim = 10)

# a Wishart variable with the same covariance parameter
theta = wishart(df = 5, Sigma = Sig)
}
