% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structures.R
\name{structures}
\alias{structures}
\alias{zeros}
\alias{ones}
\alias{greta_array}
\title{create data greta arrays}
\usage{
zeros(...)

ones(...)

greta_array(data = 0, dim = length(data))
}
\arguments{
\item{...}{dimensions of the greta arrays to create}

\item{data}{a vector giving data to fill the greta array. Other object types
are coerced by \code{\link{as.vector}}.}

\item{dim}{an integer vector giving the dimensions for the greta array to be
created.}
}
\value{
a greta array object
}
\description{
These structures can be used to set up more complex models. For
  example, scalar parameters can be embedded in a greta array by first
  creating a greta array with \code{zeros()} or \code{ones()}, and then
  embedding the parameter value using greta's replacement syntax.
}
\details{
\code{greta_array} is a convenience function to create an R array
  with \code{\link{array}} and then coerce it to a greta array. I.e. it is
  equivalent to \code{as_data(array(data, dim))}.
}
\examples{
\dontrun{

# a 3 row, 4 column greta array of 0s
z <- zeros(3, 4)

# a 3x3x3 greta array of 1s
z <- ones(3, 3, 3)

# a 2x4 greta array filled with pi
z <- greta_array(pi, dim = c(2, 4))

# a 3x3x3 greta array filled with 1, 2, and 3
z <- greta_array(1:3, dim = c(3, 3, 3))
}
}
