% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reinstallers.R
\name{reinstallers}
\alias{reinstallers}
\alias{remove_greta_env}
\alias{reinstall_greta_env}
\alias{remove_miniconda}
\alias{reinstall_miniconda}
\title{Helpers to remove, and reinstall python environments and miniconda}
\usage{
remove_greta_env()

reinstall_greta_env(timeout = 5)

remove_miniconda()

reinstall_miniconda(timeout = 5)
}
\arguments{
\item{timeout}{time in minutes to wait until timeout (default is 5 minutes)}
}
\value{
invisible
}
\description{
This can be useful when debugging greta installation to get to "clean slate".
There are four functions:
}
\details{
\itemize{
\item \code{remove_greta_env()} removes the 'greta-env' conda environment
\item \code{remove_miniconda()} removes miniconda installation
\item \code{reinstall_greta_env()} remove 'greta-env' and reinstall it using \code{greta_create_conda_env()} (which is used internally).
\item \code{reinstall_miniconda()} removes miniconda and reinstalls it using \code{greta_install_miniconda()} (which is used internally)
}
}
\examples{
\dontrun{
remove_greta_env()
remove_miniconda()
reinstall_greta_env()
reinstall_miniconda()
}
}
