% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greta_create_conda_env.R
\name{greta_create_conda_env}
\alias{greta_create_conda_env}
\title{Create conda environment for greta}
\usage{
greta_create_conda_env(timeout = 5, deps = greta_deps_spec())
}
\arguments{
\item{timeout}{time (minutes) until installation stops. Default is 5 minutes.}

\item{deps}{dependency specification, see \code{\link[=greta_deps_spec]{greta_deps_spec()}} for
more details.}
}
\value{
nothing - creates a conda environment for a specific python version
}
\description{
This function runs \code{\link[reticulate:conda-tools]{reticulate::conda_create()}} inside
\code{\link[callr:r_process_options]{callr::r_process_options()}}, to create the conda environment,
"greta-env-tf2". This is used within \code{\link[=install_greta_deps]{install_greta_deps()}} as part of
setting up python dependencies. It uses a version of python that is
compatible with the versions of tensorflow and tensorflow-probability,
which is established with  \code{\link[=greta_deps_spec]{greta_deps_spec()}}. We mostly recommend
users use \code{\link[=install_greta_deps]{install_greta_deps()}} to manage their python dependency
installation.
}
