% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmc.R
\name{rmc}
\alias{rmc}
\title{RMC test}
\usage{
rmc(data, distribution = c("dnorm", "dfnorm", "dchisq"), level = 0.95,
  style = c("mcb", "lines"), select = NULL, plot = TRUE, ...)
}
\arguments{
\item{data}{Matrix or data frame with observations in rows and variables in
columns.}

\item{distribution}{Type of the distribution to use. If this is a clear forecast error,
then \code{"dnorm"} is appropriate, leading to a simple Gausian linear
regression. \code{"dfnorm"} would lead to a alm model with folded normal
distribution. Finally, \code{"dchisq"} would lead to the alm with Chi
squared distribution. This value is passed to \code{alm()} function.}

\item{level}{The width of the confidence interval. Default is 0.95.}

\item{style}{What style of plot to use after the calculations. This can be
either "MCB" style or "Vertical lines" one.}

\item{select}{What column of data to highlight on the plot. If NULL, then
the method with the lowest value is selected.}

\item{plot}{If \code{TRUE} then the graph is produced after the calculations.
You can also use plot method on the produced object in order to get the same
effect.}

\item{...}{Other parameters passed to plot function}
}
\value{
If \code{plot=TRUE}, then the function plots the results after all
the calculations. In case of \code{distribution="dnorm"}, the closer to zero the
intervals are, the better model performs. When \code{distribution="dfnorm"} or
\code{distribution="dchisq"}, the smaller, the better.

Function returns a list of a class "rmc", which contains the following
variables:
\itemize{
\item{mean}{Mean values for each method.}
\item{interval}{Confidence intervals for each method.}
\item{vlines}{Coordinates used for style="l", marking the groups of methods.}
\item{groups}{The table containing the groups. \code{TRUE} - methods are in the
same group, \code{FALSE} - they are not.}
\item{p.value}{p-value for the test of the significance of the model. This is a
log-likelihood ratios chi-squared test, comparing the model with the one with
intercept only.}
\item{importance}{The weights of the estimated model in comparison with the
model with the constant only. 0 means that the constant is better, 1 means that
the estimated model is the best.}
\item{level}{Significance level.}
\item{model}{lm model produced for the calculation of the intervals.}
\item{style}{Style of the plot to produce.}
\item{select}{The selected variable to highlight.}
}
}
\description{
RMC stands for "Regression for Methods Comparison". This is a parametric
test for the comparison of means of several distributions
This test is a parametric counterpart of nemenyi / MCB test (Demsar, 2006) and
uses asymptotic properties of regression models. It relies on distributional
assumptions about the provided data. For instance, if the mean forecast errors
are used, then it is safe to assume that the regression model constructed on
them will have normally distributed residuals.
}
\details{
The test constructs the regression model of the kind:

y = b' X + e,

where y is the vector of the provided data (as.vector(data)), X is the matrix
of dummy variables for each column of the data (forecasting method), b is the
vector of coefficients for the dummies and e is the error term of the model.

Depending on the provided data, it might make sense to use different types of
regressions. The function supports Gausian linear regression
(\code{distribution="dnorm"}, when the data is normal), advanced linear regression with
folded normal distribution (\code{distribution="dfnorm"}, for example, absolute errors,
assuming that the original errors are normally distributed) and advanced linear
regression with Chi-Squared distribution (\code{distribution="dchisq"}, when the data is
distributed as Chi^2, for example squared normal standard errors).

The advisable error measures to use in the test are RelMAE and RelMSE, which are
unbiased and whose logarithms are symmetrically distributed (Davydenko & Fildes,
2013). In fact RelMSE should have F-distribution with h and h degrees of freedom
and its logarithm is a log F distribution, because each MSE * h has chi-square(h)
(assuming that the forecast error is normal).

As for RelMAE, its distribution is trickier, because each MAE has folded normal
distribution (assuming that the original error is normal) and their ratio is
something complicated, but tractable (Kim, 2006).

Still, given large samples, the parameters of the regression on logarithms of
the both RelMAE and RelMSE should have normal distribution. Thus
\code{distribution="dnorm"} can be used in this case (see examples).

The test is equivalent to nemenyi test, when applied to the ranks of the error
measures on large samples.

There is also a \code{plot()} method that allows producing either "mcb" or "lines"
style of plot. This can be regulated via \code{plot(x, style="lines")}.
}
\examples{
N <- 50
M <- 4
ourData <- matrix(rnorm(N*M,mean=0,sd=1), N, M)
ourData[,2] <- ourData[,2]+1
ourData[,3] <- ourData[,3]+0.7
ourData[,4] <- ourData[,4]+0.5
colnames(ourData) <- c("Method A","Method B","Method C - long name","Method D")
rmc(ourData, distribution="dnorm", level=0.95)
# In case of AE-based measures, distribution="dfnorm" should be selected
rmc(abs(ourData), distribution="dfnorm", level=0.95)

# In case of SE-based measures, distribution="dchisq" should be selected
rmc(ourData^2, distribution="dchisq", level=0.95)

# APE-based measures should not be used in general...

# If RelMAE or RelMSE is used for measuring data, then it makes sense to use
# distribution="dnorm" and provide logarithms of the RelMAE, which can be approximated by
# normal distribution
ourData <- abs(ourData)
rmc(ourData / ourData[,1], distribution="dnorm", level=0.95)

# The following example should give similar results to nemenyi test on
# large samples, which compares medians of the distributions:
rmc(t(apply(ourData,1,rank)), distribution="dnorm", level=0.95)

}
\references{
\itemize{
\item  Demsar, J. (2006). Statistical Comparisons of Classifiers over
Multiple Data Sets. Journal of Machine Learning Research, 7, 1-30.
\url{http://www.jmlr.org/papers/volume7/demsar06a/demsar06a.pdf}
\item Davydenko, A., Fildes, R. (2013). Measuring Forecasting Accuracy:
The Case Of Judgmental Adjustments To Sku-Level Demand Forecasts.
International Journal of Forecasting, 29(3), 510-522.
\url{https://doi.org/10.1016/j.ijforecast.2012.09.002}
\item Hea-Jung Kim (2006) On the Ratio of Two Folded Normal
Distributions, Communications in Statistics Theory and Methods, 35:6,
965-977, \url{https://doi.org/10.1080/03610920600672229}
}
}
\seealso{
\code{\link[greybox]{alm}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
