% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xregMultiplier.R
\name{xregMultiplier}
\alias{xregMultiplier}
\title{Exogenous variables cross-products}
\usage{
xregMultiplier(xreg, quiet = TRUE, ...)
}
\arguments{
\item{xreg}{matrix or data.frame, containing variables that need
to be expanded. This matrix needs to contain at least two columns.}

\item{quiet}{If \code{quiet=FALSE}, then the progress is printed out.
Otherwise the function won't print anything in the console.}

\item{...}{This is temporary and is needed in order to capture "quiet"
parameter if it is provided.}
}
\value{
\code{ts} matrix with the transformed and the original variables
is returned.
}
\description{
Function generates the cross-products of the provided exogenous variables.
}
\details{
This function might be useful if you have several variables and want to
introduce their cross-products. This might be useful when introducing the
interactions between dummy and continuous variables.
}
\examples{
# Create matrix of two variables and expand it
x <- cbind(rnorm(100,100,1),rnorm(100,50,3))
xregMultiplier(x)

}
\seealso{
\code{\link[smooth]{es}, \link[greybox]{stepwise},
\link[greybox]{xregExpander}, \link[greybox]{xregTransformer}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
