% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporaldummy.R
\name{temporaldummy}
\alias{temporaldummy}
\alias{temporaldummy.default}
\title{Dummy variables for provided seasonality type}
\usage{
temporaldummy(object, type = c("month", "quarter", "week", "day", "hour",
  "halfhour", "minute", "second"), of = c("year", "quarter", "month", "week",
  "day", "hour", "minute"), h = 0)

\method{temporaldummy}{default}(object, type = c("month", "quarter", "week",
  "day", "hour", "halfhour", "minute", "second"), of = c("year", "quarter",
  "month", "week", "day", "hour", "minute"), h = 0)
}
\arguments{
\item{object}{Either a ts / msts / zoo / xts / tsibble object or a vector
of dates.}

\item{type}{Specifies what type of frequency to produce. For example, if
\code{type="month"}, then the matrix with dummies for months of the year will
be created.}

\item{of}{Specifies the frequency of what is needed. Used together with \code{type}
e.g. \code{type="day"} and \code{of="month"} will produce a matrix with dummies
for days of month (31 dummies).}

\item{h}{If not \code{NULL}, then the function will produce dummies for this
set of observations ahead as well, binding them to the original matrix.}
}
\value{
Class "dgCMatrix" with all the dummy variables is returned in case of numeric
variable. Feel free to drop one (making it a reference variable) or convert the object
into matrix (this will consume more memory than the returned class). In other cases the
object of the same class as the provided is returned.
}
\description{
Function generates the matrix of dummy variables for the months / weeks / days /
hours / minutes / seconds of year / month / week / day / hour / minute.
}
\details{
The function extracts dates from the provided object and returns a matrix with
dummy variables for the specified frequency type, with the number of rows equal
to the length of the object + the specified horizon. If a numeric vector is provided
then it will produce dummies based on typical values (e.g. 30 days in month). So it
is recommended to use proper classes with this method.

Several notes on how the dummies are calculated in some special cases:
\itemize{
\item In case of weeks of years, the first week is defined according to ISO 8601.
}

Note that not all the combinations of \code{type} and \code{of} are supported. For
example, there is no such thing as dummies for months of week. Also note that some
combinations are not very useful and would take a lot of memory (e.g. minutes of year).

The function will return all the dummy variables. If you want to avoid the dummy
variables trap, you will need to exclude one of them manually.

If you want to have a different type of dummy variables, let me know, I will
implement it.
}
\examples{
# Generate matrix with dummies for a ts object
x <- ts(rnorm(100,100,1),frequency=12)
temporaldummy(x)

# Generate matrix with monthly dummies for a zoo object
x <- as.Date("2003-01-01")+0:99
temporaldummy(x, type="month", of="year", h=10)

}
\seealso{
\code{\link[greybox]{xregExpander}, \link[greybox]{xregMultiplier},
\link[greybox]{xregTransformer}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
