% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pAIC}
\alias{pAIC}
\alias{pAICc}
\alias{pBIC}
\alias{pBICc}
\title{Point AIC}
\usage{
pAIC(object, ...)

pAICc(object, ...)

pBIC(object, ...)

pBICc(object, ...)
}
\arguments{
\item{object}{Time series model.}

\item{...}{Some stuff.}
}
\value{
The function returns the vector of point AIC values.
}
\description{
This function returns a vector of AIC values for the in-sample observations
}
\details{
This is based on \link[greybox]{pointLik} function. The formula for this is:
pAIC_t = 2 * k - 2 * T * l_t ,
where k is the number of parameters, T is the number of observations and l_t is
the point likelihood. This way we preserve the property that AIC = mean(pAIC).
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
ourModel <- alm(y~x1+x2,as.data.frame(xreg))

pAICValues <- pAIC(ourModel)

mean(pAICValues)
AIC(ourModel)

}
\seealso{
\link[greybox]{pointLik}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
