% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_summary.R
\name{best_linear_projection}
\alias{best_linear_projection}
\title{Estimate the best linear projection of a conditional average treatment effect
using a causal forest.}
\usage{
best_linear_projection(forest, A = NULL, subset = NULL)
}
\arguments{
\item{forest}{The trained forest.}

\item{A}{The covariates we want to project the CATE onto.}

\item{subset}{Specifies subset of the training examples over which we
estimate the ATE. WARNING: For valid statistical performance,
the subset should be defined only using features Xi, not using
the treatment Wi or the outcome Yi.}
}
\value{
An estimate of the best linear projection, along with coefficient standard errors.
}
\description{
Let tau(Xi) = E[Y(1) - Y(0) | X = Xi] be the CATE, and Ai be a vector of user-provided
covariates. This function provides a (doubly robust) fit to the linear model
}
\details{
tau(Xi) ~ beta_0 + Ai * beta

Procedurally, we do so be regressing doubly robust scores derived from the causal
forest against the Ai. Note the covariates Ai may consist of a subset of the Xi,
or they may be distince The case of the null model tau(Xi) ~ beta_0 is equivalent
to fitting an average treatment effect via AIPW.
}
\examples{
\dontrun{
n <- 800
p <- 5
X <- matrix(rnorm(n * p), n, p)
W <- rbinom(n, 1, 0.25 + 0.5 * (X[, 1] > 0))
Y <- pmax(X[, 1], 0) * W + X[, 2] + pmin(X[, 3], 0) + rnorm(n)
forest <- causal_forest(X, Y, W)
best_linear_projection(forest, X[,1:2])
}

}
\references{
Chernozhukov, Victor, and Vira Semenova. "Simultaneous inference for
            Best Linear Predictor of the Conditional Average Treatment Effect and
            other structural functions." arXiv preprint arXiv:1702.06240 (2017).
}
