#' 'Groq': Translate Text
#'
#' @param text The text to be translated by 'Groq'. If not provided,
#' it will use what's copied on the clipboard.
#' @param toLanguage The language to be translated into.
#' @param ... Following arguments can be set manually or in .Renviron:
#'            `GROQ_API_KEY`is the 'Groq API' key.
#'            `model` Model choice. Default is mistral-7b-instruct.
#'            `systemRole` System role; Default is: "You are a helpful assistant
#'            with extensive knowledge of R programming."
#'            `maxTokens` The maximum integer of completion tokens returned.
#'            `temperature` The amount of randomness in the response,
#'            valued between 0 inclusive and 2 exclusive. Higher values are more
#'            random, and lower values are more deterministic.
#'            `top_p` Nucleus sampling threshold, valued between 0 and 1.
#'            `proxy` Default value is NULL.
#'
#'
#' @examples
#' \dontrun{
#' translater("Dear Recipient, I hope this message finds you well.")
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by 'Groq'.
#'
#' @export
#'
translater <- function(text = NULL, toLanguage = "German", ...) {
  if (is.null(text)) text <- clipr::read_clip(allow_non_interactive = TRUE)
  # Replace all double strings with single string
  code <- gsub('"', "'", text)
  # Collapse the modified 'text' into a character vector
  code <- paste(text, collapse = "\n")
  # Create a prompt string by concatenating the input code
  prompt <- paste0(
    "Can you translate the following text to ", toLanguage, ': "',
    text, '"'
  )

  return(APIcall(prompt, ...))
}
