% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_starts.R
\name{find_starts}
\alias{find_starts}
\title{Find start positions of groups in data.}
\usage{
find_starts(data, col = NULL, return_index = FALSE)
}
\arguments{
\item{data}{Dataframe or Vector}

\item{col}{Name of column to find starts in. Used when data is
dataframe. (Character)}

\item{return_index}{Return indices of starts. (Logical)}
}
\value{
Vector with either start values or indices of start values.
}
\description{
Find values or indices of values that are not the same
as the previous value. E.g. use with the \code{l_starts} method.
}
\examples{
# Attach packages
library(groupdata2)

# Create a dataframe
df <- data.frame('a' = c('a','a','b',
                         'b','c','c'))

# Get start values for new groups in column 'a'
find_starts(df, col = 'a')

# Get indices of start values for new groups
# in column 'a'
find_starts(df, col = 'a',
            return_index = TRUE)

## Use found starts with l_starts method
# Notice: This is equivalent to n = 'auto'
# with l_starts method

# Get start values for new groups in column 'a'
starts <- find_starts(df, col = 'a')

# Use starts in group() with 'l_starts' method
group(df, n = starts, method = 'l_starts',
      starts_col = 'a')

# Similar but with indices instead of values

# Get indices of start values for new groups
# in column 'a'
starts_ind <- find_starts(df, col = 'a',
                          return_index = TRUE)

# Use starts in group() with 'l_starts' method
group(df, n = starts_ind, method = 'l_starts',
      starts_col = 'index')


}
\seealso{
Other l_starts tools: \code{\link{find_missing_starts}},
  \code{\link{group_factor}}, \code{\link{group}}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
