% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_starts.R
\name{find_starts}
\alias{find_starts}
\title{Find start positions of groups in data.}
\usage{
find_starts(
  data,
  col = NULL,
  return_index = FALSE,
  handle_na = "ignore",
  factor_conversion_warning = TRUE
)
}
\arguments{
\item{data}{Data frame or Vector

N.B. If checking a factor, it is converted to a character vector.
Conversion will generate a warning, which can be turned off by
setting \code{factor_conversion_warning} to \code{FALSE}.}

\item{col}{Name of column to find starts in. Used when data is
data frame. (Character)}

\item{return_index}{Return indices of starts. (Logical)}

\item{handle_na}{How to handle \code{NA}s in the column.

\subsection{"ignore"}{
Removes the \code{NA}s before finding the differing values, ensuring
that the first value after an \code{NA} will be correctly identified as new,
if it differs from the value before the \code{NA}(s).
}

\subsection{"as_element"}{
Treats all \code{NA}s as the string \code{"NA"}.
This means, that \code{threshold} must be \code{NULL} when using this method.
}

\subsection{Numeric scalar}{
A numeric value to replace \code{NA}s with.
}}

\item{factor_conversion_warning}{Generate warning when
converting factor to character. (Logical)}
}
\value{
Vector with either start values or indices of start values.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

Finds values or indices of values that are not the same
as the previous value.

E.g. to use with the \code{l_starts} method.

Wraps \code{\link{differs_from_previous}()}.
}
\examples{
# Attach packages
library(groupdata2)

# Create a data frame
df <- data.frame(
  "a" = c("a", "a", "b", "b", "c", "c"),
  stringsAsFactors = FALSE
)

# Get start values for new groups in column 'a'
find_starts(df, col = "a")

# Get indices of start values for new groups
# in column 'a'
find_starts(df,
  col = "a",
  return_index = TRUE
)

## Use found starts with l_starts method
# Notice: This is equivalent to n = 'auto'
# with l_starts method

# Get start values for new groups in column 'a'
starts <- find_starts(df, col = "a")

# Use starts in group() with 'l_starts' method
group(df,
  n = starts, method = "l_starts",
  starts_col = "a"
)

# Similar but with indices instead of values

# Get indices of start values for new groups
# in column 'a'
starts_ind <- find_starts(df,
  col = "a",
  return_index = TRUE
)

# Use starts in group() with 'l_starts' method
group(df,
  n = starts_ind, method = "l_starts",
  starts_col = "index"
)
}
\seealso{
Other l_starts tools: 
\code{\link{differs_from_previous}()},
\code{\link{find_missing_starts}()},
\code{\link{group_factor}()},
\code{\link{group}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{l_starts tools}
