% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_group_cols.R
\name{summarize_group_cols}
\alias{summarize_group_cols}
\title{Summarize group columns}
\usage{
summarize_group_cols(data, group_cols, long = TRUE)
}
\arguments{
\item{data}{\code{data.frame} with one or more group columns (\code{factor}s) to summarize.}

\item{group_cols}{Names of columns to summarize. These columns must be factors in \code{`data`}.}

\item{long}{Whether the output should be in \emph{long} or \emph{wide} format.}
}
\value{
Data frame (\code{tibble}) with summary statistics for each column in \code{`group_cols`}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Get the following summary statistics for each group column:
\enumerate{
\item Number of groups
\item Mean, median, std., IQR, min, and max number of rows per group.
}

The output can be given in either \emph{long} (default) or \emph{wide} format.
}
\examples{
# Attach packages
library(groupdata2)

# Create data frame
df <- data.frame(
  "some_var" = runif(25),
  "grp_1" = factor(sample(1:5, size = 25, replace=TRUE)),
  "grp_2" = factor(sample(1:8, size = 25, replace=TRUE)),
  "grp_3" = factor(sample(LETTERS[1:3], size = 25, replace=TRUE)),
  "grp_4" = factor(sample(LETTERS[1:12], size = 25, replace=TRUE))
)

# Summarize the group columns (long format)
summarize_group_cols(
  data = df,
  group_cols = paste0("grp_", 1:4),
  long = TRUE
 )

# Summarize the group columns (wide format)
summarize_group_cols(
  data = df,
  group_cols = paste0("grp_", 1:4),
  long = FALSE
 )
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{summarization functions}
