% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{atmospheric_CO2}
\alias{atmospheric_CO2}
\title{Atmospheric CO2 concentration}
\usage{
atmospheric_CO2(year)
}
\arguments{
\item{year}{Calender year for which to extract CO2 concentration.}
}
\value{
Approximate CO2 concentration in ppm for given year.
}
\description{
Retrieve CO2 concentration (in ppm) for given calendar year.
}
\details{
This function defines the CO2 concentration as a function of calendar
year. it is based on a polynomial fit to the annual CO2 data
published by NOAA
<https://gml.noaa.gov/webdata/ccgg/trends/co2/co2_annmean_gl.txt>
}
\note{
This is only approximately valid for years in the range 1949 - 2020
}
\examples{
atmospheric_CO2(1990)
atmospheric_CO2(2020)
# Insensible
atmospheric_CO2(1800)

}
