% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_group.R
\name{FunctionalGroup}
\alias{FunctionalGroup}
\title{Representation of a grassland plant population}
\description{
A functional group is a representation of a grassland plant population
with certain functional attributes.

It contains many plant parameters that are collected under the hood of
functional groups. The class implements S3 style operator overloading such
that one can do things like

\if{html}{\out{<div class="sourceCode">}}\preformatted{mixed_functional_group = 0.8 * FG_A + 0.2 * FG_B
}\if{html}{\out{</div>}}
}
\section{Public fields}{
\itemize{
\item \code{SLA} Specific Leaf Area in m^2^ per g.
\item \code{pcLAM} Percentage of laminae (number between 0 and 1).
\item \code{ST1} Temperature sum in degree Celsiues days after which the
seasonality function \code{SEA} starts to decrease from its maximum plateau.
See also \code{\link[=SEA]{SEA()}}.
\item \code{ST2} Temperature sum in degree Celsiues days after which the
seasonality function \code{SEA} has decreased back to its minimum value.
See also \code{\link[=SEA]{SEA()}}.
\item \code{maxSEA} Maximum value of the seasonality function \code{\link[=SEA]{SEA()}}
\item \code{minSEA} Minimum value of the seasonality function \code{\link[=SEA]{SEA()}}. Usually,
\code{minSEA = 1 - (maxSEA - 1)}.
\item \code{maxOMDGV} Maximum organic matter digestability for green vegetative
matter in arbitrary units.
\item \code{minOMDGV} Minimum organic matter digestability for green vegetative
matter in arbitrary units.
\item \code{maxOMDGR} Maximum organic matter digestability for green reproductive
matter in arbitrary units.
\item \code{minOMDGR} Minimum organic matter digestability for green reproductive
matter in arbitrary units.
\item \code{BDGV} Bulk density of green vegetative dry matter in g per m^3^.
\item \code{BDDV} Bulk density of dead vegetative dry matter in g per m^3^.
\item \code{BDGR} Bulk density of green reproductive dry matter in g per m^3^.
\item \code{BDDR} Bulk density of dead reproductive dry matter in g per m^3^.
\item \code{fg_parameter_names} Vector of strings of the variable names of all
vegetation parameters governed by functional group composition.
}

Default values for parameters are taken from functional group A in
Jouven et al.
}

\references{
\insertRef{jouven2006ModelPredictingDynamics}{growR}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fg_parameter_names}}{Names of the vegetation parameters governed by
functional group composition.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FunctionalGroup-new}{\code{FunctionalGroup$new()}}
\item \href{#method-FunctionalGroup-get_parameters}{\code{FunctionalGroup$get_parameters()}}
\item \href{#method-FunctionalGroup-get_parameters_ordered}{\code{FunctionalGroup$get_parameters_ordered()}}
\item \href{#method-FunctionalGroup-set_parameters}{\code{FunctionalGroup$set_parameters()}}
\item \href{#method-FunctionalGroup-set_parameters_ordered}{\code{FunctionalGroup$set_parameters_ordered()}}
\item \href{#method-FunctionalGroup-clone}{\code{FunctionalGroup$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionalGroup-new"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionalGroup-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionalGroup$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Key-value pairs of parameters to be set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionalGroup-get_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionalGroup-get_parameters}{}}}
\subsection{Method \code{get_parameters()}}{
Convenient getter

Returns all parameters with their names in a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionalGroup$get_parameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionalGroup-get_parameters_ordered"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionalGroup-get_parameters_ordered}{}}}
\subsection{Method \code{get_parameters_ordered()}}{
Ordered getter

Returns all parameters in reproducible order in a vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionalGroup$get_parameters_ordered()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionalGroup-set_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionalGroup-set_parameters}{}}}
\subsection{Method \code{set_parameters()}}{
Convenient setter

Set all specified parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionalGroup$set_parameters(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Key-value pairs of parameters to be set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionalGroup-set_parameters_ordered"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionalGroup-set_parameters_ordered}{}}}
\subsection{Method \code{set_parameters_ordered()}}{
Efficient setter, assumes parameters come in known order.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionalGroup$set_parameters_ordered(ordered_parameter_values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ordered_parameter_values}}{Parameter values to be set. Need to be
in the same order as pFunctionalGroup]\verb{$fg_parameter_names}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionalGroup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionalGroup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionalGroup$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
