% Generated by roxygen2 (4.0.1): do not edit by hand
\name{gmrfdpgrow}
\alias{gmrfdpgrow}
\title{Bayesian instrinsic Gaussian Markov Random Field model for dependent time-indexed functions}
\usage{
gmrfdpgrow(y, ipr, q_order, q_type, q_shape, q_rate, tau_shape, tau_rate,
  dp_shape, dp_rate, M_init, n.iter, n.burn, n.thin, progress, jitter,
  kappa_fast)
}
\arguments{
\item{y}{A multivariate continuous response, specified as an \emph{N x T} matrix, where \code{N}
denotes the number of functions and \code{T}, the number of time points per function. Intermittent
missing-at-random values are allowed and will be estimated from the posterior
predictive distribution.  Missing cells should be denoted with \code{NA}.}

\item{ipr}{An optional input vector of inclusion probabilities for each observation unit in the case
the observed data were acquired through an informative sampling design, so that unbiased
inference about the population requires adjustments to the observed sample.  Defaults to
\code{ipr = rep(1,nrow(y))} indicating an iid sample.}

\item{q_order}{An integer vector of length \code{K} to select the order for each iGMRF precision term.
e.g. If the first term is a RW2 and there is a second is a 3-month seasonality term, where the time
points are indexed by month, then \code{q_order = c(2,3)}.  Defaults to \code{q_order = 2}}

\item{q_type}{A vector of length \code{K}, the number of iGMRF precision terms, with each entry
indicating whether the associated term is a trend (\code{"tr"}) or seasonality (\code{"sn"}) term.
So all entries must be one of \code{c("tr","sn")}. Defaults to \code{q_type = "tr"}.}

\item{q_shape}{The value (in (0,infty)) for the shape hyperparameter for the Gamma base distribution for
the iGMRF scale parameters, \code{kappa_star(k,m)}, where \code{k} denotes the term
and \code{m}, the cluster.  Defaults to \code{q_shape = 0.3}.}

\item{q_rate}{The rate parameter of the Gamma base distribution on \code{kappa_star}.
Defaults to \code{q_rate = 0.0005}.}

\item{tau_shape}{The value (in (0,infty)) for the shape hyperparameter for the Gamma prior on the error
precision parameter. Defaults to \code{tau_shape = 1.0}.}

\item{tau_rate}{The rate parameter of the Gamma prior distribution on \code{tau_e}.
Defaults to \code{tau_rate = 1}.}

\item{dp_shape}{The shape parameter for the Gamma prior on the DP concentration parameter,
\code{conc}. Defaults to \code{dp_shape = 1}.}

\item{dp_rate}{The rate parameter for the Gamma prior on the DP concentration parameter,
\code{conc}. Defaults to \code{dp_rate = 1}.}

\item{M_init}{Starting number of clusters of \code{nrow(y)} units to initialize sampler.
Defaults to \code{M_init = nrow(y)}.}

\item{n.iter}{Total number of MCMC iterations.}

\item{n.burn}{Number of MCMC iterations to discard.
\code{gmrfdpgrow} will return \code{(n.iter - n.burn)} posterior samples.}

\item{n.thin}{Gap between successive sampling iterations to save.}

\item{progress}{A boolean value denoting whether to display a progress bar during model execution.
Defaults to \code{progress = true}.}

\item{jitter}{A scalar double indicating amount of jitter to subract from the posterior
rate and shape hyperparameters of \code{tau_e} to stabilize computation.
Defaults to \code{jitter = 0.0}.}

\item{kappa_fast}{Boolean for whether to generate rate hyperparameter from full conditionals
versus joint Gaussian (on random effects, \code{bb}, given \code{kappa}.  The
former is faster, but numerically less stable.
Defaults to \code{kappa_fast = FALSE}.}
}
\value{
S3 \code{gmrfdpgrow} object, for which many methods are available to return and view results.
       Generic functions applied to an object, \code{res} of class \code{gmrfdpgrow}, includes:
  \item{plot(res)}{ returns results plots, including fit functions versus data and allocation
                 of fitted functions into clusters}
 	\item{samples(res)}{ contains (\code{n.iter - n.burn}) posterior sampling iterations
            for every model parameter}
	\item{resid(res)}{ contains the model residuals.}
}
\description{
Estimates a collection of time-indexed functions under intrinsic Gaussian Markov random
field prior formulations where a Dirichlet process mixture allows sub-groupings of the functions to share the same
iGMRF precision parameter.  The iGMRF formulation supports any number of additive precision terms,
expressing either or both of multiple trend and seasonality.
}
\note{
The intended focus for this package are data composed of observed noisy functions (each of
       length \code{T}) for a set of experimental units where the functions may express dependence
       among the experimental units
}
\examples{
{
library(growfunctions)

## load the monthly employment count data for a collection of
## U.S. states from the Current
## Population Survey (cps)
data(cps)
## subselect the columns of N x T, y, associated
## with the years 2008 - 2013
## to examine the state level employment levels
## during the "great recession"
y_short   <- cps$y[,(cps$yr_label \%in\% c(2008:2013))]

## Run the DP mixture of iGMRF's to estimate posterior
## distributions for model parameters
## Under default RW2(kappa) = order 2 trend
## precision term
## Run for 1500 iterations, with half as burn-in for a
## more useful (converged) result.
res_gmrf            <- gmrfdpgrow(y = y_short,
                                     n.iter = 40,
                                     n.burn = 20,
                                     n.thin = 1)

## 2 plots of estimated functions: 1. faceted by cluster and fit;
## 2.  data for experimental units.
## for a group of randomly-selected functions
fit_plots_gmrf      <- cluster_plot( object = res_gmrf,
                                     units_name = "state",
                                     units_label = cps$st,
                                     single_unit = FALSE,
                                     credible = TRUE )
}
}
\author{
Terrance Savitsky \email{tds151@gmail.com} Daniell toth \email{danielltoth@yahoo.com}
}
\references{
T. D. Savitsky and D. Toth (2014) Bayesian Non-parametric Models for Collections of Time-
    indexed Functions. submitted to: JRSS Series A (Statistics in Society).

T. D. Savitsky (2014) Bayesian Non-parametric Functional Mixture
    Estimation for Time-indexed data. submitted to: Annals of Applied Statistics.

T. D. Savitsky (2014) Bayesian Non-Parametric Mixture Estimation for Time-Indexed Functional
    Data for \code{R}. Submitted to: Journal of Statistical Software.
}
\seealso{
\code{\link{gmrfdpgrow}}
}
\keyword{model}

