% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{ewma}
\alias{ewma}
\title{Exponentially Weighted Moving Average (EWMA)}
\usage{
ewma(agedays, z, ewma.exp, ewma.adjacent = TRUE)
}
\arguments{
\item{agedays}{Vector of age in days for each z score (potentially transformed to adjust weighting).}

\item{z}{Input vector of numeric z-score data.}

\item{ewma.exp}{Exponent to use for weighting.}

\item{ewma.adjacent}{Specify whether EWMA values excluding adjacent measurements should be calculated.  Defaults to TRUE.}
}
\value{
Data frame with 3 variables:
\itemize{
\item The first variable (ewma.all) contains the EWMA at observation time
excluding only the actual observation for that time point.
\item The second variable (ewma.before) contains the EWMA for each observation excluding both the actual observation
and the immediate prior observation.
\item The third variable (ewma.after) contains the EWMA for each observation excluding both the actual observation
and the subsequent observation.
}
}
\description{
\code{ewma} calculates the exponentially weighted moving average (EWMA) for a set of numeric observations over time.
}
\examples{
# Run on 1 subject, 1 type of parameter
df_stats <- as.data.frame(syngrowth)
df_stats <- df_stats[df_stats$subjid == df_stats$subjid[1] &
                       df_stats$param == "HEIGHTCM", ]

# Get the uncentered z-scores
measurement_to_z <- read_anthro(cdc.only = TRUE)
sd <- measurement_to_z(df_stats$param,
                       df_stats$agedays,
                       df_stats$sex,
                       df_stats$measurement,
                       TRUE)

# Calculate exponentially weighted moving average
e_df <- ewma(df_stats$agedays, sd, ewma.exp = -1.5)
}
