% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_exponential.R
\name{grow_exponential}
\alias{grow_exponential}
\title{Exponential Growth Model}
\usage{
grow_exponential(time, parms)
}
\arguments{
\item{time}{vector of time steps (independent variable).}

\item{parms}{named parameter vector of the exponential growth model with:
\itemize{
  \item \code{y0} initial abundance (e.g. concentration of bacterial cells).
  \item \code{mumax} maximum growth rate (1/time).
}}
}
\value{
vector of dependent variable (\code{y}) and its log-transformed
  values (\code{log_y}).
}
\description{
Unlimited exponential growth model.
}
\details{
The equation used is:
\deqn{y = y0 * exp(mumax * time)}
}
\examples{

time <- seq(0, 30, length=200)
y <- grow_exponential(time, c(y0=1, mumax=0.5))[,"y"]
plot(time, y, type="l")

}
\seealso{
Other growth models: \code{\link{grow_baranyi}},
  \code{\link{grow_gompertz}}, \code{\link{grow_huang}},
  \code{\link{grow_logistic}}, \code{\link{grow_richards}},
  \code{\link{growthmodel}}, \code{\link{ode_genlogistic}},
  \code{\link{ode_twostep}}
}

