## ------------------------------------------------------------------------
data(Birthwt)
head(Birthwt$X, n=3)

## ------------------------------------------------------------------------
Birthwt$group

## ------------------------------------------------------------------------
X <- Birthwt$X
y <- Birthwt$bwt
group <- Birthwt$group
fit <- grpreg(X, y, group, penalty="grLasso")

## ----opts.label='fig'----------------------------------------------------
plot(fit)

## ----opts.label='fig'----------------------------------------------------
coef(fit, lambda=0.05)

## ----opts.label='fig'----------------------------------------------------
cvfit <- cv.grpreg(X, y, group, penalty="grLasso")
plot(cvfit)

## ------------------------------------------------------------------------
coef(cvfit)

## ------------------------------------------------------------------------
predict(cvfit, X=head(X))
predict(cvfit, type="ngroups")

