% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.grpreg.R
\name{predict.grpreg}
\alias{predict.grpreg}
\title{Model predictions for a fitted \code{grpreg} object}
\usage{
\method{predict}{grpreg}(object, newdata, lambda = NULL,
  type = c("response", "class", "probability"), ...)
}
\arguments{
\item{object}{A fitted "\code{grpreg}" object from \code{\link{grpss}},
or \code{\link[grpreg]{grpreg}} function.}

\item{newdata}{Optionally, a matrix or data frame where to predict. If omits, the fitted
predictors are used.}

\item{lambda}{Value of the regularization parameter \code{lambda} at which predictions are
requested. See details for the default.}

\item{type}{The type of prediction: "\code{response}" gives the fitted values; \code{"class"}
returns the predicted class for the binomial outcome; "\code{probability}" returns the
predicted probabilities for the logistic regression.}

\item{...}{Not used.}
}
\value{
The predicted values depending on the type.
}
\description{
Similar to usual predict methods and \code{predict.grprep} in \code{grpreg} package.
}
\details{
This function gives the predictions at \code{newdata} or all predictors if the
argument \code{newdata} is not supplied. The default \code{lambda} for "\code{grpreg}"
object is the one at which we obtain the minimum loss value, i.e., negative log-likelihood
value. Typically, \code{type = "response"} is
used for linear or poisson regression, and \code{type = "class"} or
\code{type = "probability"} is used for logistic regression.
}
\examples{
library(MASS)
set.seed(23)
n <- 30 # sample size
p <- 3  # number of predictors in each group
J <- 50  # group size
group <- rep(1:J,each = 3)  # group indices
X <- mvrnorm(n,seq(0,5,length.out = p*J),diag(p*J))
beta <- runif(12,-2,5)
mu <- X\%*\%matrix(c(beta,rep(0,p*J-12)),ncol = 1)

# linear regression with family = "gaussian"
y <-  mu + rnorm(n)

## without cross-validation
gss12 <- grpss(X,y,ncut = 10,group,select = TRUE)
predict(gss12) # fitted values
predict(gss12,lambda = 0.2) # fitted values at lambda = 0.2

# logistic regression with family = "binomial"
set.seed(23)
y1 <- rbinom(n,1,1/(1 + exp(-mu)))
gss21 <- grpss(X,y1,group, criterion = "gDC",select = TRUE,
               family = "binomial")
predict(gss21)
}
\author{
Debin Qiu, Jeongyoun Ahn
}
\seealso{
\code{\link{grpss}}
}

