% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridpts_h1_hupdate.R
\name{gridpts}
\alias{gridpts}
\title{Grid points for group sequential design numerical integration}
\usage{
gridpts(r = 18, mu = 0, a = -Inf, b = Inf)
}
\arguments{
\item{r}{Integer, at least 2; default of 18 recommended by Jennison and Turnbull.}

\item{mu}{Mean of normal distribution (scalar) under consideration.}

\item{a}{Lower limit of integration (scalar).}

\item{b}{Upper limit of integration (scalar \verb{> a}).}
}
\value{
A list with grid points in \code{z} and numerical integration weights in \code{w}.
}
\description{
Points and weights for Simpson's rule numerical integration from
p 349--350 of Jennison and Turnbull book.
This is not used for arbitrary integration, but for the canonical form of Jennison and Turnbull.
mu is computed elsewhere as drift parameter times sqrt of information.
Since this is a lower-level routine, no checking of input is done; calling routines should
ensure that input is correct.
Lower limit of integration can be \code{-Inf} and upper limit of integration can be \code{Inf}.
}
\details{
Jennison and Turnbull (p 350) claims accuracy of \code{10e-6} with \code{r=16}.
The numerical integration grid spreads out at the tail to enable accurate tail probability calculations.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Define odd numbered grid points for real line.
   \item Trim points outside of $[a, b]$ and include those points.
   \item If extreme, include only 1 point where density will be essentially 0.
   \item Define even numbered grid points between the odd ones.
   \item Compute weights for odd numbered grid points.
   \item Combine odd- and even-numbered grid points with their corresponding weights.
   \item Return a tibble of with grid points in z and numerical integration weights in z.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
# Approximate variance of standard normal (i.e., 1)
g <- gridpts()
sum((g$z)^2 * g$w * dnorm(g$z))

# Approximate probability above .95 quantile (i.e., 0.05)
g <- gridpts(a = qnorm(0.95), b = Inf)
sum(g$w * dnorm(g$z))
}
