% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_power_ahr.R
\name{gs_power_ahr}
\alias{gs_power_ahr}
\title{Group sequential design power using average hazard ratio under
non-proportional hazards}
\usage{
gs_power_ahr(
  enroll_rate = tibble(stratum = "All", duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = tibble(stratum = "All", duration = c(3, 100), fail_rate = log(2)/c(9, 18),
    hr = c(0.9, 0.6), dropout_rate = rep(0.001, 2)),
  event = c(30, 40, 50),
  analysis_time = NULL,
  upper = gs_b,
  upar = gsDesign(k = length(event), test.type = 1, n.I = event, maxn.IPlan = max(event),
    sfu = sfLDOF, sfupar = NULL)$upper$bound,
  lower = gs_b,
  lpar = c(qnorm(0.1), rep(-Inf, 2)),
  test_lower = TRUE,
  test_upper = TRUE,
  ratio = 1,
  binding = FALSE,
  info_scale = c(0, 1, 2),
  r = 18,
  tol = 1e-06,
  interval = c(0.01, 100)
)
}
\arguments{
\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{event}{Targeted event at each analysis.}

\item{analysis_time}{Minimum time of analysis.}

\item{upper}{Function to compute upper bound.}

\item{upar}{Parameters passed to \code{upper}.}

\item{lower}{Function to compute lower bound.}

\item{lpar}{Parameters passed to \code{lower}.}

\item{test_lower}{Indicator of which analyses should include an lower bound;
single value of \code{TRUE} (default) indicates all analyses;
single value of \code{FALSE} indicated no lower bound;
otherwise, a logical vector of the same length as \code{info} should indicate
which analyses will have a lower bound.}

\item{test_upper}{Indicator of which analyses should include an upper
(efficacy) bound; single value of \code{TRUE} (default) indicates all analyses;
otherwise, a logical vector of the same length as \code{info} should
indicate which analyses will have an efficacy bound.}

\item{ratio}{Experimental:Control randomization ratio (not yet implemented).}

\item{binding}{Indicator of whether futility bound is binding;
default of \code{FALSE} is recommended.}

\item{info_scale}{The information scale for calculation.}

\item{r}{Integer value controlling grid for numerical integration as in
Jennison and Turnbull (2000); default is 18, range is 1 to 80.
Larger values provide larger number of grid points and greater accuracy.
Normally, \code{r} will not be changed by the user.}

\item{tol}{Tolerance parameter for boundary convergence (on Z-scale).}

\item{interval}{An interval that is presumed to include the time at which
expected event count is equal to targeted event.}
}
\value{
A tibble with columns \code{Analysis}, \code{Bound}, \code{Z}, \code{Probability},
\code{theta}, \code{Time}, \code{AHR}, \code{Events}.
Contains a row for each analysis and each bound.
}
\description{
Group sequential design power using average hazard ratio under
non-proportional hazards.
}
\details{
Bound satisfy input upper bound specification in
\code{upper}, \code{upar}, and lower bound specification in \code{lower}, \code{lpar}.
\code{\link[=ahr]{ahr()}} computes statistical information at targeted event times.
The \code{\link[=expected_time]{expected_time()}} function is used to get events and average HR at
targeted \code{analysis_time}.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Calculate information and effect size based on AHR approximation
   using \code{gs_info_ahr()}.
   \item Return a tibble of with columns Analysis, Bound, Z, Probability,
   theta, Time, AHR, Events and  contains a row for each analysis
   and each bound.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(gsDesign2)
library(dplyr)

# Example 1 -----------------------------------------------------------------
# The default output of `gs_power_ahr()` is driven by events,
# i.e., `event = c(30, 40, 50)`, `analysis_time = NULL`
\donttest{
gs_power_ahr()
}
# Example 2 -----------------------------------------------------------------
# 2-sided symmetric O'Brien-Fleming spending bound, driven by analysis time,
# i.e., `event = NULL`, `analysis_time = c(12, 24, 36)`

gs_power_ahr(
  analysis_time = c(12, 24, 36),
  event = NULL,
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL)
)

# Example 3 -----------------------------------------------------------------
# 2-sided symmetric O'Brien-Fleming spending bound, driven by event,
# i.e., `event = c(20, 50, 70)`, `analysis_time = NULL`
\donttest{
gs_power_ahr(
  analysis_time = NULL,
  event = c(20, 50, 70),
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL)
)
}
# Example 4 -----------------------------------------------------------------
# 2-sided symmetric O'Brien-Fleming spending bound,
# driven by both `event` and `analysis_time`, i.e.,
# both `event` and `analysis_time` are not `NULL`,
# then the analysis will driven by the maximal one, i.e.,
# Time = max(analysis_time, calculated Time for targeted event)
# Events = max(events, calculated events for targeted analysis_time)
\donttest{
gs_power_ahr(
  analysis_time = c(12, 24, 36),
  event = c(30, 40, 50),
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL)
)
}
}
