% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.R
\name{define_fail_rate}
\alias{define_fail_rate}
\title{Define fail rate}
\usage{
define_fail_rate(duration, fail_rate, dropout_rate, hr = 1, stratum = "All")
}
\arguments{
\item{duration}{A numeric vector of piecewise study duration interval.}

\item{fail_rate}{A numeric vector of failure rate in each \code{duration}.}

\item{dropout_rate}{A numeric vector of dropout rate in each \code{duration}.}

\item{hr}{A numeric vector of hazard ratio.}

\item{stratum}{A character vector of stratum name.}
}
\value{
A \code{fail_rate} data frame.
}
\description{
Define fail rate
}
\examples{
# Define enroll rate without stratum
define_fail_rate(
  duration = c(3, 100),
  fail_rate = log(2) / c(9, 18),
  hr = c(.9, .6),
  dropout_rate = .001
)

# Define enroll rate with stratum
define_fail_rate(
  duration = c(3, 100),
  fail_rate = log(2) / c(9, 18),
  hr = c(.9, .6),
  dropout_rate = .001,
  stratum = c("low", "high")
)
}
