% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_design_ahr.R
\name{gs_design_ahr}
\alias{gs_design_ahr}
\title{Group sequential design using average hazard ratio under non-proportional hazards}
\usage{
gs_design_ahr(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = define_fail_rate(duration = c(3, 100), fail_rate = log(2)/c(9, 18), hr =
    c(0.9, 0.6), dropout_rate = 0.001),
  alpha = 0.025,
  beta = 0.1,
  info_frac = NULL,
  analysis_time = 36,
  ratio = 1,
  binding = FALSE,
  upper = gs_b,
  upar = gsDesign::gsDesign(k = 3, test.type = 1, n.I = c(0.25, 0.75, 1), sfu = sfLDOF,
    sfupar = NULL)$upper$bound,
  lower = gs_b,
  lpar = c(qnorm(0.1), -Inf, -Inf),
  h1_spending = TRUE,
  test_upper = TRUE,
  test_lower = TRUE,
  info_scale = c("h0_h1_info", "h0_info", "h1_info"),
  r = 18,
  tol = 1e-06,
  interval = c(0.01, 100)
)
}
\arguments{
\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{alpha}{One-sided Type I error.}

\item{beta}{Type II error.}

\item{info_frac}{Targeted information fraction at each analysis.}

\item{analysis_time}{Minimum time of analysis.}

\item{ratio}{Experimental:Control randomization ratio (not yet implemented).}

\item{binding}{Indicator of whether futility bound is binding;
default of \code{FALSE} is recommended.}

\item{upper}{Function to compute upper bound.}

\item{upar}{Parameters passed to \code{upper}.}

\item{lower}{Function to compute lower bound.}

\item{lpar}{Parameters passed to \code{lower}.}

\item{h1_spending}{Indicator that lower bound to be set by spending
under alternate hypothesis (input \code{fail_rate})
if spending is used for lower bound.}

\item{test_upper}{Indicator of which analyses should include an upper
(efficacy) bound; single value of \code{TRUE} (default) indicates all analyses;
otherwise, a logical vector of the same length as \code{info} should indicate
which analyses will have an efficacy bound.}

\item{test_lower}{Indicator of which analyses should include an lower bound;
single value of \code{TRUE} (default) indicates all analyses;
single value \code{FALSE} indicated no lower bound; otherwise, a logical vector
of the same length as \code{info} should indicate which analyses will have a
lower bound.}

\item{info_scale}{Information scale for calculation. Options are:
\itemize{
\item \code{"h0_h1_info"} (default): variance under both null and alternative hypotheses is used.
\item \code{"h0_info"}: variance under null hypothesis is used.
\item \code{"h1_info"}: variance under alternative hypothesis is used.
}}

\item{r}{Integer value controlling grid for numerical integration as in
Jennison and Turnbull (2000); default is 18, range is 1 to 80.
Larger values provide larger number of grid points and greater accuracy.
Normally, \code{r} will not be changed by the user.}

\item{tol}{Tolerance parameter for boundary convergence (on Z-scale).}

\item{interval}{An interval that is presumed to include the time at which
expected event count is equal to targeted event.}
}
\value{
A list with input parameters, enrollment rate, analysis, and bound.
}
\description{
Group sequential design using average hazard ratio under non-proportional hazards
}
\details{
To be added.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if input analysis_time is a positive number or positive
   increasing sequence.
   \item Validate if input info_frac is a positive number or positive
   increasing sequence
   on (0, 1] with final value of 1.
   \item Validate if input info_frac and analysis_time  have the same
   length if both have length > 1.
   \item Get information at input analysis_time
   \itemize{
     \item Use \code{gs_info_ahr()} to get the information and effect size
     based on AHR approximation.
     \item Extract the final event.
     \item Check if input If needed for (any) interim analysis timing.
   }
   \item Add the analysis column to the information at input analysis_time.
   \item Add the sample size column to the information at input analysis_time
   using \code{expected_accural()}.
   \item Get sample size and bounds using \code{gs_design_npe()} and
   save them to bounds.
   \item Add Time, Events, AHR, N that have already been calculated
   to the bounds.
   \item Return a list of design enrollment, failure rates, and bounds.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(gsDesign)
library(gsDesign2)
library(dplyr)

# ----------------- #
#    example 1      #
# ----------------- #
# call with defaults
gs_design_ahr()

# ----------------- #
#    example 2      #
# ----------------- #
# Single analysis
gs_design_ahr(analysis_time = 40)

# ----------------- #
#    example 3      #
# ----------------- #
# Multiple analysis_time
gs_design_ahr(analysis_time = c(12, 24, 36))

# ----------------- #
#    example 4      #
# ----------------- #
# Specified information fraction
\donttest{
gs_design_ahr(info_frac = c(.25, .75, 1), analysis_time = 36)
}

# ----------------- #
#    example 5      #
# ----------------- #
# multiple analysis times & info_frac
# driven by times
gs_design_ahr(info_frac = c(.25, .75, 1), analysis_time = c(12, 25, 36))
# driven by info_frac
\donttest{
gs_design_ahr(info_frac = c(1 / 3, .8, 1), analysis_time = c(12, 25, 36))
}

# ----------------- #
#    example 6      #
# ----------------- #
# 2-sided symmetric design with O'Brien-Fleming spending
\donttest{
gs_design_ahr(
  analysis_time = c(12, 24, 36),
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  h1_spending = FALSE
)
}
# 2-sided asymmetric design with O'Brien-Fleming upper spending
# Pocock lower spending under H1 (NPH)
\donttest{
gs_design_ahr(
  analysis_time = c(12, 24, 36),
  binding = TRUE,
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL),
  lower = gs_spending_bound,
  lpar = list(sf = gsDesign::sfLDPocock, total_spend = 0.1, param = NULL, timing = NULL),
  h1_spending = TRUE
)
}

# ----------------- #
#    example 7      #
# ----------------- #
\donttest{
gs_design_ahr(
  alpha = 0.0125,
  analysis_time = c(12, 24, 36),
  upper = gs_spending_bound,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.0125, param = NULL, timing = NULL),
  lower = gs_b,
  lpar = rep(-Inf, 3)
)

gs_design_ahr(
  alpha = 0.0125,
  analysis_time = c(12, 24, 36),
  upper = gs_b,
  upar = gsDesign::gsDesign(
    k = 3, test.type = 1, n.I = c(.25, .75, 1),
    sfu = sfLDOF, sfupar = NULL, alpha = 0.0125
  )$upper$bound,
  lower = gs_b,
  lpar = rep(-Inf, 3)
)
}
}
