% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.R
\name{get_calendartime_gsnb}
\alias{get_calendartime_gsnb}
\title{Calendar time of data looks}
\usage{
get_calendartime_gsnb(rate1, rate2, dispersion, t_recruit1, t_recruit2, timing,
  followup1, followup2)
}
\arguments{
\item{rate1}{numeric; rate in treatment group 1}

\item{rate2}{numeric; rate in treatment group 2}

\item{dispersion}{numeric; dispersion (shape) parameter of negative binomial distribution}

\item{t_recruit1}{numeric vector; recruit (i.e. study entry) times in group 1}

\item{t_recruit2}{numeric vector; recruit (i.e. study entry) times in group 2}

\item{timing}{numeric vector with entries in (0,1]; information times of data looks}

\item{followup1}{numeric vector; final individual follow-up times in treatment group 1}

\item{followup2}{numeric vector; final individual follow-up times in treatment group 2}
}
\value{
numeric; vector with calendar time of data looks
}
\description{
Calculate the calendar time of looks given the information time
}
\examples{
# Calendar time at which 50\%, 75\%, and 100\% of the maximum information is attained
# 100 subjects in each group are recruited uniformly over 1.5 years
# Study ends after two years, i.e. follow-up times vary between 2 and 0.5 years 
get_calendartime_gsnb(rate1 = 0.1, 
                      rate2 = 0.125, 
                      dispersion = 5, 
                      t_recruit1 = seq(0, 1.5, length.out = 100), 
                      t_recruit2 = seq(0, 1.5, length.out = 100),
                      timing = c(0.5, 0.75, 1),
                      followup1 = seq(2, 0.5, length.out = 100),
                      followup2 = seq(2, 0.5, length.out = 100)) 
}
