% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtfilt.R
\name{filtfilt}
\alias{filtfilt}
\alias{filtfilt.default}
\alias{filtfilt.Arma}
\alias{filtfilt.Ma}
\alias{filtfilt.Sos}
\alias{filtfilt.Zpg}
\title{Zero-phase digital filtering}
\usage{
filtfilt(filt, ...)

\method{filtfilt}{default}(filt, a, x, ...)

\method{filtfilt}{Arma}(filt, x, ...)

\method{filtfilt}{Ma}(filt, x, ...)

\method{filtfilt}{Sos}(filt, x, ...)

\method{filtfilt}{Zpg}(filt, x, ...)
}
\arguments{
\item{filt}{For the default case, the moving-average coefficients of an ARMA
filter (normally called ‘b’). Generically, \code{filt} specifies an
arbitrary filter operation.}

\item{...}{additional arguments (ignored).}

\item{a}{the autoregressive (recursive) coefficients of an ARMA filter,
specified as a vector. If \code{a[1]} is not equal to 1, then filter
normalizes the filter coefficients by \code{a[1]}. Therefore, \code{a[1]}
must be nonzero.}

\item{x}{the input signal to be filtered. If \code{x} is a matrix, all
colums are filtered.}
}
\value{
The filtered signal, normally of the same length of the input signal
  \code{x}, returned as a vector or matrix.
}
\description{
Forward and reverse filter the signal.
}
\details{
Forward and reverse filtering the signal corrects for phase distortion
introduced by a one-pass filter, though it does square the magnitude response
in the process. That’s the theory at least. In practice the phase correction
is not perfect, and magnitude response is distorted, particularly in the stop
band.

Before filtering the input signal is extended with a reflected part of both
ends of the signal. The length of this extension is 3 times the filter order.
Gustafsson's [1] method is then used to specify the initial conditions used
to further handle the edges of the signal.
}
\examples{
bf <- butter(3, 0.1)                                 # 10 Hz low-pass filter
t <- seq(0, 1, len = 100)                            # 1 second sample
x <- sin(2* pi * t * 2.3) + 0.25 * rnorm(length(t))  # 2.3 Hz sinusoid+noise
z <- filter(bf, x)                                   # apply filter
plot(t, x, type = "l")
lines(t, z, col = "red")
zz <- filtfilt(bf, x)
lines(t, zz, col="blue")
legend("bottomleft", legend = c("original", "filter", "filtfilt"), lty = 1,
 col = c("black", "red", "blue"))

}
\references{
[1] Gustafsson, F. (1996). Determining the initial states in
  forward-backward filtering. IEEE Transactions on Signal Processing, 44(4),
  988 - 992.
}
\seealso{
\code{\link{filter}}, \code{\link{filter_zi}}, \code{\link{Arma}},
  \code{\link{Sos}}, \code{\link{Zpg}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net},\cr Francesco Potortì,
  \email{pot@gnu.org},\cr Luca Citi, \email{lciti@essex.ac.uk}.\cr
  Conversion to R and adapted by Geert van Boxtel
  \email{G.J.M.vanBoxtel@gmail.com}.
}
