% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/besselap.R
\name{besselap}
\alias{besselap}
\title{Bessel analog low-pass filter prototype}
\usage{
besselap(n)
}
\arguments{
\item{n}{order of the filter; must be < 25.}
}
\value{
List of class \code{\link{Zpg}} containing poles and gain of the
  filter
}
\description{
Return the poles and gain of a Bessel analog low-pass filter prototype.
}
\details{
The transfer function is
\if{latex}{
  \deqn{H(s) = \frac{k}{(s-p(1))(s-p(2))...(s-p(n))}}
}
\if{html}{\preformatted{
                     k
 H(s) = -----------------------------
         (s-p(1))(s-p(2))...(s-p(n))

}}
\code{besselap} normalizes the poles and gain so that at low frequency and
high frequency the Bessel prototype is asymptotically equivalent to the
Butterworth prototype of the same order. The magnitude of the filter is less
than \eqn{1/\sqrt{2}} at the unity cutoff frequency \eqn{\Omega_c = 1}.

Analog Bessel filters are characterized by a group delay that is maximally
flat at zero frequency and almost constant throughout the passband. The group
delay at zero frequency is
\if{latex}{
  \deqn{\left( \frac{(2n)!}{2^{n}n!} \right) ^{1/n}}
}
\if{html}{\preformatted{
   /  (2n!) \ 2
   | ------ |
   \ 2^n n! /
}}
}
\examples{
## 6th order Bessel low-pass analog filter
zp <- besselap(6)
w <- seq(0, 4, length.out = 128)
freqs(zp, w)

}
\references{
\url{https://en.wikipedia.org/wiki/Bessel_polynomials}
}
\author{
Thomas Sailer, email{t.sailer@alumni.ethz.ch}.\cr Conversion to R by
  Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
