% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diric.R
\name{diric}
\alias{diric}
\title{Dirichlet function}
\usage{
diric(x, n)
}
\arguments{
\item{x}{Input array, specified as a real scalar, vector, matrix, or
multidimensional array. When \code{x} is non-scalar, \code{diric} is an
element-wise operation.}

\item{n}{Function degree, specified as a positive integer scalar.}
}
\value{
Output array, returned as a real-valued scalar, vector, matrix, or
  multidimensional array of the same size as x.
}
\description{
Compute the Dirichlet or periodic sinc function.
}
\details{
\code{y <- diric(x, n)} returns the Dirichlet Function of degree \code{n}
evaluated at the elements of the input array \code{x}.

The Dirichlet function, or periodic sinc function, has period \eqn{2 \pi} for
odd \eqn{N} and period \eqn{4 \pi} for even \eqn{N}. Its maximum value is 1
for all N, and its minimum value is -1 for even N. The magnitude of the
function is 1 / N times the magnitude of the discrete-time Fourier transform
of the N-point rectangular window.
}
\examples{

## Compute and plot the Dirichlet function between -2pi and 2pi for N = 7
## and N = 8. The function has a period of 2pi for odd N and 4pi for even N.
x <- seq(-2*pi, 2*pi, len = 301)
d7 <- diric(x, 7)
d8 <- diric(x, 8)
op <- par(mfrow = c(2,1))
plot(x/pi, d7, type="l", main = "Dirichlet function",
     xlab = "", ylab = "N = 7")
plot(x/pi, d8, type="l", ylab = "N = 8", xlab = expression(x / pi))
par(op)

}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
