#include <gsl/gsl_sf_airy.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name.  Thus gsl_sf_airy_Ai goes to airy_Ai. */

static sf_mode[] = { GSL_PREC_DOUBLE , GSL_PREC_SINGLE , GSL_PREC_APPROX } ;


void airy_Ai_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  gsl_set_error_handler_off();
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Ai_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  


void airy_Bi_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Bi_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}  


void airy_Ai_scaled_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Ai_scaled_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}   



void airy_Bi_scaled_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Bi_scaled_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}   


void airy_Ai_deriv_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Ai_deriv_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}   


void airy_Bi_deriv_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Bi_deriv_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}   


void airy_Ai_deriv_scaled_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Ai_deriv_scaled_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}   

void airy_Bi_deriv_scaled_e(double *x, int *nx, int *mode, double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  
  for(i = 0; i< *nx ; i++){
    status[i]  = gsl_sf_airy_Bi_deriv_scaled_e(x[i] , sf_mode[*mode] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}   


void airy_zero_Ai_e(int *n , int *nn , double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  for(i = 0; i< *nn ; i++){
    status[i]  = gsl_sf_airy_zero_Ai_e(n[i] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}


void airy_zero_Bi_e(int *n , int *nn , double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  for(i = 0; i< *nn ; i++){
    status[i]  = gsl_sf_airy_zero_Bi_e(n[i] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}



void airy_zero_Ai_deriv_e(int *n , int *nn , double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  for(i = 0; i< *nn ; i++){
    status[i]  = gsl_sf_airy_zero_Ai_deriv_e(n[i] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}



void airy_zero_Bi_deriv_e(int *n , int *nn , double *val, double *err, int *status)
{
  int i;
  gsl_sf_result result;
  for(i = 0; i< *nn ; i++){
    status[i]  = gsl_sf_airy_zero_Bi_deriv_e(n[i] , &result) ;
    val[i] = result.val;
    err[i] = result.err;
  }
}
