\name{mkint}
\alias{mkint}
\title{
    Generating Integrals of Basis Terms
}
\description{
    Generate integrals of basis terms for use in the ssden1 suite.
}
\usage{
mkint(mf, type, id.basis, quad, term, rho, rho.int)
}
\arguments{
    \item{mf}{Model frame of the model formula.}
    \item{type}{List specifying the type of spline for each variable.}
    \item{id.basis}{Index of observations to be used as "knots."}
    \item{quad}{Quadratures on marginal domains, weighted by rho.}
    \item{term}{Model terms generated by \code{mkterm}.}
    \item{rho}{Marginal log(rho) on quadrature points.}
    \item{rho.int}{Marginal integrals of log(rho).}
}
\details{
    \code{mkint} calculates the first and second moments of basis
    functions with respect to the indepent joint density rho; the second
    moments are needed in \code{project.ssden1}.
}
\value{
    A list of seven components.
    \item{s}{First moments of phi's.}
    \item{r}{First moments of rk's.}
    \item{s.rho}{Cross moments of phi*log(rho).}
    \item{r.rho}{Cross moments of rk*log(rho).}
    \item{ss}{Second moments of phi's.}
    \item{sr}{Cross moments of phi's and rk's.}
    \item{rr}{Second moments of rk.}
}
\author{Chong Gu, \email{chong@stat.purdue.edu}}
\keyword{internal}
