% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_rho_t_exact}
\alias{gsw_rho_t_exact}
\title{In-situ density}
\usage{
gsw_rho_t_exact(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
in-situ density [ kg/m^3 ]
}
\description{
In-situ density
}
\examples{
gsw_rho_t_exact(34.7118, 28.7856, 10) # 1021.840173185531
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_rho_t_exact.html}
}
\seealso{
\code{\link{gsw_rho}} is similar but uses SA and CT; SA may be computed from UNESCO quantities using \code{\link{gsw_SA_from_SP}}.
}

