% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_enthalpy_second_derivatives}
\alias{gsw_enthalpy_second_derivatives}
\title{Second Derivatives of Enthalpy}
\usage{
gsw_enthalpy_second_derivatives(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing \code{h_SA_SA} [ (J/kg)/(g/kg)^2 ], the second derivative of
enthalpy with respect to Absolute Salinity, \code{h_SA_CT} [ (J/kg)/(K*g/kg) ], the derivative of
enthalpy with respect to Absolute Salinity and Conservative Temperature,
and \code{h_CT_CT} [ (J/kg)/degC^2 ], the second derivative of
enthalpy with respect to Conservative Temperature.
}
\description{
Second Derivatives of Enthalpy
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
r <- gsw_enthalpy_second_derivatives(SA, CT, p)
expect_equal(r$h_SA_SA, c(0.000080922482023, 0.000404963500641, 0.001059800046742,
                        0.002431088963823, 0.006019611828423, 0.010225411250217))
expect_equal(r$h_SA_CT, c(0.000130004715129, 0.000653614489248, 0.001877220817849,
                        0.005470392103793, 0.014314756132297, 0.025195603327700))
expect_equal(r$h_CT_CT, c(0.000714303909834, 0.003584401249266, 0.009718730753139,
                        0.024064471995224, 0.061547884081343, 0.107493969308119))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_enthalpy_second_derivatives.html}
}
