% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_rho_second_derivatives}
\alias{gsw_rho_second_derivatives}
\title{Second Derivatives of Density}
\usage{
gsw_rho_second_derivatives(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing \code{rho_SA_SA} [ (kg/m^3)/(g/kg)^2 ], the second derivative of
density with respect to Absolute Salinity,
\code{rho_SA_CT} [ (g/kg)/(g/kg)/degC ], the derivative of
density with respect to Absolute Salinity and Conservative Temperature,
and \code{rho_CT_CT} [ (kg/m^3)/degC^2 ], the second derivative of
density with respect to Conservative Temperature.
}
\description{
Second Derivatives of Density
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
r <- gsw_rho_second_derivatives(SA, CT, p)
expect_equal(r$rho_SA_SA/1e-3, c(0.207364734477357, 0.207415414547223, 0.192903197286004,
                               0.135809142211237, 0.122627562106076, 0.114042431905783))
expect_equal(r$rho_SA_CT, c(-0.001832856561477, -0.001837354806146, -0.001988065808078,
                          -0.002560181494807, -0.002708939446458, -0.002798484050141))
expect_equal(r$rho_CT_CT, c(-0.007241243828334, -0.007267807914635, -0.007964270843331,
                          -0.010008164822017, -0.010572200761984, -0.010939294762200))
expect_equal(r$rho_SA_p/1e-8, c(-0.087202931942412, -0.087558612009845, -0.092549696987409,
                              -0.106661486272630, -0.110022261844240, -0.112287954816717))
expect_equal(r$rho_CT_p/1e-8, c(-0.116597992537549, -0.117744271236102, -0.141712549466964,
                              -0.214414626736539, -0.237704139801551, -0.255296606034074))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_rho_second_derivatives.html}
}
