% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_from_pt}
\alias{gsw_entropy_from_pt}
\title{Specific Entropy ito Absolute Salinity and Potential Temperature}
\usage{
gsw_entropy_from_pt(SA, pt)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{pt}{potential temperature (ITS-90) [ degC ]}
}
\value{
specific entropy [ J/(kg*degC) ]
}
\description{
Calculates specific entropy in terms of Absolute Salinity and
Potential Temperature.
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
pt <- c(28.7832, 28.4210, 22.7850, 10.2305,  6.8292,  4.3245)
e <- gsw_entropy_from_pt(SA, pt)
expect_equal(e/1e2, c(4.003894674443156, 3.954383994925507, 3.198674385897981,
                    1.467905482842553, 0.986469100565646, 0.627913567234252))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_from_pt.html}
}
\seealso{
Other things related to entropy: \code{\link{gsw_CT_from_entropy}},
  \code{\link{gsw_entropy_first_derivatives}},
  \code{\link{gsw_entropy_from_t}},
  \code{\link{gsw_entropy_ice}},
  \code{\link{gsw_pt_from_entropy}}
}
