% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_second_derivatives}
\alias{gsw_pt_second_derivatives}
\title{Second Derivatives of Potential Temperature}
\usage{
gsw_pt_second_derivatives(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
A list containing \code{pt_SA_SA} [ K/(g/kg)^2 ], the second derivative of
potential temperature with respect to Absolute Salinity at constant
potential temperature, and \code{pt_SA_pt} [ 1/(g/kg) ], the derivative of
potential temperature with respect to Conservative Temperature and
Absolute Salinity, and \code{pt_pt_pt} [ 1/degC ], the second derivative of
potential temperature with respect to Conservative Temperature.
}
\description{
Second Derivatives of Potential Temperature
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
r <- gsw_pt_second_derivatives(SA, CT)
stopifnot(all.equal(r$pt_SA_SA/1e-3,
    c(0.160307058371208, 0.160785497957769, 0.168647220588324,
      0.198377949876584, 0.210181899321236, 0.220018966513329)))
stopifnot(all.equal(r$pt_SA_CT,
    c(0.001185581323691, 0.001187068518686, 0.001217629686266,
      0.001333254154015, 0.001379674342678, 0.001418371539325)))
stopifnot(all.equal(r$pt_CT_CT/1e-3,
    c(-0.121979811279463, -0.123711264754503, -0.140136818504977,
      -0.140645384127949, -0.113781055410824, -0.082417269009484)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_second_derivatives.html}
}
