% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_first_derivatives_wrt_t_exact}
\alias{gsw_CT_first_derivatives_wrt_t_exact}
\title{Derivatives of Conservative Temperature with Respect to or at
Constant in-situ Temperature}
\usage{
gsw_CT_first_derivatives_wrt_t_exact(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
A list containing \code{CT_SA_wrt_t} [ K/(g/kg) ], the derivative of
Conservative Temperature with respect to Absolute Salinity at constant
temperature and pressure, \code{CT_t_wrt_t} [ unitless], the derivative of
Conservative Temperature with respect to temperature at constant
Absolute Salinity and pressure, and \code{CT_p_wrt_t}, the derivative
of Conservative Temperature with respect to pressure at constant Absolute
Salinity and temperature.
}
\description{
Derivatives of Conservative Temperature with Respect to or at
Constant in-situ Temperature
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
t <- c( 28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
r <- gsw_CT_first_derivatives_wrt_t_exact(SA, t, p)
stopifnot(all.equal(r$CT_SA_wrt_t,
    c(-0.041988694538987, -0.041596549088952, -0.034853545749326,
      -0.019067140454607, -0.015016439826591, -0.012233725491373)))
stopifnot(all.equal(r$CT_t_wrt_t,
    c(1.002752642867571, 1.002243118597902, 1.000835702767227,
      0.998194915250648, 0.995219303532390, 0.991780205482695)))
stopifnot(all.equal(r$CT_p_wrt_t/1e-7,
    c(-0.241011880838437, -0.239031676279078, -0.203649928441505,
      -0.119370679226136, -0.099140832825342, -0.086458168643579)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_first_derivatives_wrt_t_exact.html}
}
