% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_Nsquared}
\alias{gsw_Nsquared}
\title{Calculate Brunt Vaisala Frequency squared}
\usage{
gsw_Nsquared(SA, CT, p, latitude = 0)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
list containing N2 [ 1/s^2 ] and mid-point pressure p_mid [ dbar ]
}
\description{
The result is computed based on first-differencing a computed density with
respect pressure, and this can yield noisy results with CTD data that
have not been smoothed and decimated. It also yields infinite values,
for repeated adjacent pressure (e.g. this occurs twice with the \code{ctd}
dataset provided in the \CRANpkg{oce} package).
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
p <- c(      10,      50,     125,     250,     600,    1000)
latitude <- 4
r <- gsw_Nsquared(SA, CT, p, latitude=4)
stopifnot(all.equal(r$N2*1e3, c(0.060843209693499, 0.235723066151305, 0.216599928330380,
                                0.012941204313372, 0.008434782795209)))
stopifnot(all.equal(r$p_mid, c(30, 87.5, 187.5, 425, 800)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_Nsquared.html}
}
