% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{ggplot_image}
\alias{ggplot_image}
\title{Helper function for adding a ggplot}
\usage{
ggplot_image(plot_object, height = 100, aspect_ratio = 1)
}
\arguments{
\item{plot_object}{\emph{A ggplot plot object}

\verb{obj:<ggplot>} // \strong{required}

A \code{ggplot} plot object.}

\item{height}{\emph{Height of image}

\verb{scalar<numeric|integer>} // \emph{default:} \code{100}

The absolute height of the output image in the table cell (in \code{"px"}
units). By default, this is set to \code{"100px"}.}

\item{aspect_ratio}{\emph{The final aspect ratio of plot}

\verb{scalar<numeric|integer>} // \emph{default:} \code{1.0}

This is the plot's final aspect ratio. Where the height of the plot is
fixed using the \code{height} argument, the \code{aspect_ratio} will either compress
(\code{aspect_ratio} < \code{1.0}) or expand (\code{aspect_ratio} > \code{1.0}) the plot
horizontally. The default value of \code{1.0} will neither compress nor expand
the plot.}
}
\value{
A character object with an HTML fragment that can be placed inside of
a cell.
}
\description{
We can add a \strong{ggplot2} plot inside of a table with the help of the
\code{ggplot_image()} function. The function provides a convenient way to generate
an HTML fragment with a \code{ggplot} object. Because this function is currently
HTML-based, it is only useful for HTML table output. To use this function
inside of data cells, it is recommended that the \code{\link[=text_transform]{text_transform()}} function
is used. With that function, we can specify which data cells to target and
then include a call to \code{ggplot_image()} within the required user-defined
function (for the \code{fn} argument). If we want to include a plot in other
places (e.g., in the header, within footnote text, etc.) we need to use
\code{ggplot_image()} within the \code{\link[=html]{html()}} helper function.

By itself, the function creates an HTML image tag with an image URI embedded
within (a 100 dpi PNG). We can easily experiment with any \code{ggplot2} plot
object, and using it within \verb{ggplot_image(plot_object = <plot object>}
evaluates to:

\verb{<img src=<data URI> style=\\"height:100px;\\">}

where a height of \verb{100px} is a default height chosen to work well within the
heights of most table rows. There is the option to modify the aspect ratio of
the plot (the default \code{aspect_ratio} is \code{1.0}) and this is useful for
elongating any given plot to fit better within the table construct.
}
\section{Examples}{


Create a \strong{ggplot} plot.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(ggplot2)

plot_object <-
  ggplot(
    data = gtcars,
    aes(x = hp, y = trq, size = msrp)
  ) +
  geom_point(color = "blue") +
  theme(legend.position = "none")
}\if{html}{\out{</div>}}

Create a tibble that contains two cells (where one is a placeholder for an
image), then, create a \strong{gt} table. Use the \code{text_transform()} function to
insert the plot using by calling \code{ggplot_object()} within the user- defined
function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::tibble(
  text = "Here is a ggplot:",
  ggplot = NA
) |>
  gt() |>
  text_transform(
    locations = cells_body(columns = ggplot),
    fn = function(x) \{
      plot_object |>
        ggplot_image(height = px(200))
    \}
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_ggplot_image_1.png" alt="This image of a table was generated from the first code example in the `ggplot_image()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

9-3
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other image addition functions: 
\code{\link{local_image}()},
\code{\link{test_image}()},
\code{\link{web_image}()}
}
\concept{image addition functions}
