% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_column_labels}
\alias{cells_column_labels}
\title{Location helper for targeting the column labels}
\usage{
cells_column_labels(columns = everything())
}
\arguments{
\item{columns}{\emph{Columns to target}

\verb{<column-targeting expression>} // \emph{default:} \code{everything()}

The columns to which targeting operations are constrained. Can either
be a series of column names provided in \code{c()}, a vector of column indices,
or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}},
\code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}).}
}
\value{
A list object with the classes \code{cells_column_labels} and
\code{location_cells}.
}
\description{
\code{cells_column_labels()} is used to target the table's column
labels when applying a footnote with \code{\link[=tab_footnote]{tab_footnote()}} or adding custom style
with \code{\link[=tab_style]{tab_style()}}. The function is expressly used in each of those
functions' \code{locations} argument. The 'column_labels' location is present by
default in every \strong{gt} table.
}
\section{Targeting columns with the \code{columns} argument}{


The \code{columns} argument allows us to target a subset of columns contained in
the table. We can declare column names in \code{c()} (with bare column names or
names in quotes) or we can use \strong{tidyselect}-style expressions. This can be
as basic as supplying a select helper like \code{starts_with()}, or, providing a
more complex incantation like

\code{where(~ is.numeric(.x) && max(.x, na.rm = TRUE) > 1E6)}

which targets numeric columns that have a maximum value greater than
1,000,000 (excluding any \code{NA}s from consideration).
}

\section{Examples}{


Let's use a small portion of the \code{\link{sza}} dataset to create a \strong{gt} table.
Add footnotes to the column labels with \code{\link[=tab_footnote]{tab_footnote()}} and
\code{cells_column_labels()} in \code{locations}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sza |>
  dplyr::filter(
    latitude == 20 & month == "jan" &
      !is.na(sza)
  ) |>
  dplyr::select(-latitude, -month) |>
  gt() |>
  tab_footnote(
    footnote = "True solar time.",
    locations = cells_column_labels(
      columns = tst
    )
  ) |>
  tab_footnote(
    footnote = "Solar zenith angle.",
    locations = cells_column_labels(
      columns = sza
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cells_column_labels_1.png" alt="This image of a table was generated from the first code example in the `cells_column_labels()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-15
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other location helper functions: 
\code{\link{cells_body}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{location-helper}}
}
\concept{location helper functions}
