% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_number}
\alias{vec_fmt_number}
\title{Format a vector as numeric values}
\usage{
vec_fmt_number(
  x,
  decimals = 2,
  n_sigfig = NULL,
  drop_trailing_zeros = FALSE,
  drop_trailing_dec_mark = TRUE,
  use_seps = TRUE,
  accounting = FALSE,
  scale_by = 1,
  suffixing = FALSE,
  pattern = "{x}",
  sep_mark = ",",
  dec_mark = ".",
  force_sign = FALSE,
  locale = NULL,
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{\emph{The input vector}

\code{vector(numeric|integer)} // \strong{required}

This is the input vector that will undergo transformation to a character
vector of the same length. Values within the vector will be formatted.}

\item{decimals}{\emph{Number of decimal places}

\code{scalar<numeric|integer>(val>=0)} // \emph{default:} \code{2}

This corresponds to the exact number of decimal places to use. A value
such as \code{2.34} can, for example, be formatted with \code{0} decimal places and
it would result in \code{"2"}. With \code{4} decimal places, the formatted value
becomes \code{"2.3400"}.}

\item{n_sigfig}{\emph{Number of significant figures}

\code{scalar<numeric|integer>(val>=1)} // \emph{default:} \code{NULL} (\code{optional})

A option to format numbers to \emph{n} significant figures. By default, this is
\code{NULL} and thus number values will be formatted according to the number of
decimal places set via \code{decimals}. If opting to format according to the
rules of significant figures, \code{n_sigfig} must be a number greater than or
equal to \code{1}. Any values passed to the \code{decimals} and \code{drop_trailing_zeros}
arguments will be ignored.}

\item{drop_trailing_zeros}{\emph{Drop any trailing zeros}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

A logical value that allows for removal of trailing zeros (those redundant
zeros after the decimal mark).}

\item{drop_trailing_dec_mark}{\emph{Drop the trailing decimal mark}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

A logical value that determines whether decimal marks should always appear
even if there are no decimal digits to display after formatting (e.g., \code{23}
becomes \code{23.} if \code{FALSE}). By default trailing decimal marks are not shown.}

\item{use_seps}{\emph{Use digit group separators}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

An option to use digit group separators. The type of digit group separator
is set by \code{sep_mark} and overridden if a locale ID is provided to \code{locale}.
This setting is \code{TRUE} by default.}

\item{accounting}{\emph{Use accounting style}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

An option to use accounting style for values. Normally, negative values
will be shown with a minus sign but using accounting style will instead put
any negative values in parentheses.}

\item{scale_by}{\emph{Scale values by a fixed multiplier}

\verb{scalar<numeric|integer>} // \emph{default:} \code{1}

All numeric values will be multiplied by the \code{scale_by} value before
undergoing formatting. Since the \code{default} value is \code{1}, no values will be
changed unless a different multiplier value is supplied. This value will be
ignored if using any of the \code{suffixing} options (i.e., where \code{suffixing} is
not set to \code{FALSE}).}

\item{suffixing}{\emph{Specification for large-number suffixing}

\verb{scalar<logical>|vector<character>} // \emph{default:} \code{FALSE}

The \code{suffixing} option allows us to scale and apply suffixes to larger
numbers (e.g., \code{1924000} can be transformed to \verb{1.92M}). This option can
accept a logical value, where \code{FALSE} (the default) will not perform this
transformation and \code{TRUE} will apply thousands (\code{"K"}), millions (\code{"M"}),
billions (\code{"B"}), and trillions (\code{"T"}) suffixes after automatic value
scaling.

We can alternatively provide a character vector that serves as a
specification for which symbols are to used for each of the value ranges.
These preferred symbols will replace the defaults (e.g.,
\code{c("k", "Ml", "Bn", "Tr")} replaces \code{"K"}, \code{"M"}, \code{"B"}, and \code{"T"}).

Including \code{NA} values in the vector will ensure that the particular range
will either not be included in the transformation (e.g.,
\code{c(NA, "M", "B", "T")} won't modify numbers at all in the thousands range)
or the range will inherit a previous suffix (e.g., with
\code{c("K", "M", NA, "T")}, all numbers in the range of millions and billions
will be in terms of millions).

Any use of \code{suffixing} (where it is not set expressly as \code{FALSE}) means
that any value provided to \code{scale_by} will be ignored.

If using \code{system = "ind"} then the default suffix set provided by
\code{suffixing = TRUE} will be the equivalent of \code{c(NA, "L", "Cr")}. This
doesn't apply suffixes to the thousands range, but does express values in
\emph{lakhs} and \emph{crores}.}

\item{pattern}{\emph{Specification of the formatting pattern}

\verb{scalar<character>} // \emph{default:} \code{"{x}"}

A formatting pattern that allows for decoration of the formatted value. The
formatted value is represented by the \code{{x}} (which can be used multiple
times, if needed) and all other characters will be interpreted as string
literals.}

\item{sep_mark}{\emph{Separator mark for digit grouping}

\verb{scalar<character>} // \emph{default:} \code{","}

The string to use as a separator between groups of digits. For example,
using \code{sep_mark = ","} with a value of \code{1000} would result in a formatted
value of \code{"1,000"}. This argument is ignored if a \code{locale} is supplied
(i.e., is not \code{NULL}).}

\item{dec_mark}{\emph{Decimal mark}

\verb{scalar<character>} // \emph{default:} \code{"."}

The string to be used as the decimal mark. For example, using
\code{dec_mark = ","} with the value \code{0.152} would result in a formatted value
of \code{"0,152"}). This argument is ignored if a \code{locale} is supplied (i.e., is
not \code{NULL}).}

\item{force_sign}{\emph{Forcing the display of a positive sign}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Should the positive sign be shown for positive values (effectively showing
a sign for all values except zero)? If so, use \code{TRUE} for this option. The
default is \code{FALSE}, where only negative numbers will display a minus sign.
This option is disregarded when using accounting notation with
\code{accounting = TRUE}.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for formatting values
according the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can call \code{\link[=info_locales]{info_locales()}} for a
useful reference for all of the locales that are supported.}

\item{output}{\emph{Output format}

\verb{singl-kw:[auto|plain|html|latex|rtf|word]} // \emph{default:} \code{"auto"}

The output style of the resulting character vector. This can either be
\code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"}, or
\code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the \code{"auto"}
option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
With numeric values in a vector, we can perform number-based formatting so
that the values are rendered to a character vector with some level of
precision. The following major options are available:
\itemize{
\item decimals: choice of the number of decimal places, option to drop
trailing zeros, and a choice of the decimal symbol
\item digit grouping separators: options to enable/disable digit separators
and provide a choice of separator symbol
\item scaling: we can choose to scale targeted values by a multiplier value
\item large-number suffixing: larger figures (thousands, millions, etc.) can
be autoscaled and decorated with the appropriate suffixes
\item pattern: option to use a text pattern for decoration of the formatted
values
\item locale-based formatting: providing a locale ID will result in number
formatting specific to the chosen locale
}
}
\section{Examples}{


Let's create a numeric vector for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{num_vals <- c(5.2, 8.65, 0, -5.3, NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_number()} with the default options will create a character
vector where the numeric values have two decimal places and \code{NA} values will
render as \code{"NA"}. Also, the rendering context will be autodetected unless
specified in the \code{output} argument (here, it is of the \code{"plain"} output
type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number(num_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "5.20" "8.65" "0.00" "-5.30" "NA"
}\if{html}{\out{</div>}}

We can change the decimal mark to a comma, and we have to be sure to change
the digit separator mark from the default comma to something else (a period
works here):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number(num_vals, sep_mark = ".", dec_mark = ",")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "5,20" "8,65" "0,00" "-5,30" "NA"
}\if{html}{\out{</div>}}

If we are formatting for a different locale, we could supply the locale ID
and let \strong{gt} handle these locale-specific formatting options:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number(num_vals, locale = "fr")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "5,20" "8,65" "0,00" "-5,30" "NA"
}\if{html}{\out{</div>}}

There are many options for formatting values. Perhaps you need to have
explicit positive and negative signs? Use \code{force_sign = TRUE} for that.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number(num_vals, force_sign = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "+5.20" "+8.65" "0.00" "-5.30" "NA"
}\if{html}{\out{</div>}}

Those trailing zeros past the decimal mark can be stripped out by using the
\code{drop_trailing_zeros} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number(num_vals, drop_trailing_zeros = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "5.2" "8.65" "0" "-5.3" "NA"
}\if{html}{\out{</div>}}

As a last example, one can wrap the values in a pattern with the \code{pattern}
argument. Note here that \code{NA} values won't have the pattern applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number(num_vals, pattern = "`\{x\}`")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "`5.20`" "`8.65`" "`0.00`" "`-5.30`" "NA"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

15-1
}

\section{Function Introduced}{

\code{v0.7.0} (Aug 25, 2022)
}

\seealso{
The variant function intended for formatting \strong{gt} table data:
\code{\link[=fmt_number]{fmt_number()}}.

Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_index}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_roman}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_spelled_num}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
