% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt.R
\name{gt}
\alias{gt}
\title{Create a \strong{gt} table object}
\usage{
gt(
  data,
  rowname_col = "rowname",
  groupname_col = dplyr::group_vars(data),
  rownames_to_stub = FALSE,
  auto_align = TRUE,
  id = NULL,
  row_group.sep = getOption("gt.row_group.sep", " - ")
)
}
\arguments{
\item{data}{A \code{data.frame} object or a tibble.}

\item{rowname_col}{The column name in the input \code{data} table to use as row
captions to be placed in the display table stub. If the \code{rownames_to_stub}
option is \code{TRUE} then any column name provided to \code{rowname_col} will be
ignored.}

\item{groupname_col}{The column name in the input \code{data} table to use as
group labels for generation of stub row groups. If the input \code{data} table
has the \code{grouped_df} class (through use of the \code{\link[dplyr:group_by]{dplyr::group_by()}} function
or associated \verb{group_by*()} functions) then any input here is ignored.}

\item{rownames_to_stub}{An option to take rownames from the input \code{data}
table as row captions in the display table stub.}

\item{auto_align}{Optionally have column data be aligned depending on the
content contained in each column of the input \code{data}. Internally, this
calls \code{cols_align(align = "auto")} for all columns.}

\item{id}{The table ID. By default, with \code{NULL}, this will be a random,
ten-letter ID as generated by using the \code{\link[=random_id]{random_id()}} function. A custom
table ID can be used with any single-length character vector.}

\item{row_group.sep}{The separator to use between consecutive group names (a
possibility when providing \code{data} as a \code{grouped_df} with multiple groups)
in the displayed stub row group label.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt()} function creates a \strong{gt} table object when provided with table
data. Using this function is the first step in a typical \strong{gt} workflow.
Once we have the \strong{gt} table object, we can perform styling transformations
before rendering to a display table of various formats.
}
\details{
There are a few data ingest options we can consider at this stage. We can
choose to create a table stub with rowname captions using the \code{rowname_col}
argument. Further to this, stub row groups can be created with the
\code{groupname_col}. Both arguments take the name of a column in the input table
data. Typically, the data in the \code{groupname_col} will consist of categories
of data in a table and the data in the \code{rowname_col} are unique labels
(perhaps unique across the entire table or unique within groups).

Row groups can also be created by passing a \code{grouped_df} to \code{gt()} by using
the \code{\link[dplyr:group_by]{dplyr::group_by()}} function on the table data. In this way, two or more
columns of categorical data can be used to make row groups. The
\code{row_group.sep} argument allows for control in how the row group label will
appear in the display table.
}
\section{Figures}{

\if{html}{\figure{man_gt_1.png}{options: width=100\%}}

\if{html}{\figure{man_gt_2.png}{options: width=100\%}}
}

\section{Function ID}{

1-1
}

\examples{
# Create a table object using the
# `exibble` dataset; use the `row`
# and `group` columns to add a stub
# and row groups
tab_1 <-
  exibble \%>\%
  gt(
    rowname_col = "row",
    groupname_col = "group"
  )

# The resulting object can be used
# in transformations (with `tab_*()`,
# `fmt_*()`, `cols_*()` functions)
tab_2 <-
  tab_1 \%>\%
  tab_header(
    title = "Table Title",
    subtitle = "Subtitle"
  ) \%>\%
  fmt_number(
    columns = vars(num),
    decimals = 2
  ) \%>\%
  cols_label(num = "number")

}
\seealso{
Other Create Table: 
\code{\link{gt_preview}()}
}
\concept{Create Table}
