% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_tables.R
\name{info_paletteer}
\alias{info_paletteer}
\title{View a table with info on color palettes}
\usage{
info_paletteer(color_pkgs = NULL)
}
\arguments{
\item{color_pkgs}{A vector of color packages that determines which sets of
palettes should be displayed in the information table. If this is
\code{NULL} (the default) then all of the discrete palettes from all of the
color packages represented in \strong{paletteer} will be displayed.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
While the \code{\link[=data_color]{data_color()}} function allows us to flexibly color data cells in
our \strong{gt} table, the harder part of this process is discovering and
choosing color palettes that are suitable for the table output. We can make
this process much easier in two ways: (1) by using the \strong{paletteer}
package, which makes a wide range of palettes from various R packages readily
available, and (2) calling the \code{info_paletteer()} function to give us an
information table that serves as a quick reference for all of the discrete
color palettes available in \strong{paletteer}.
}
\details{
The palettes displayed are organized by package and by palette name. These
values are required when obtaining a palette (as a vector of hexadecimal
colors), from the the \code{paletteer::paletteer_d()} function. Once we are
familiar with the names of the color palette packages (e.g.,
\strong{RColorBrewer}, \strong{ggthemes}, \strong{wesanderson}), we can narrow down
the content of this information table by supplying a vector of such package
names to \code{color_pkgs}.

Colors from the following color packages (all supported by \strong{paletteer})
are shown by default with \code{info_paletteer()}:
\itemize{
\item \strong{awtools}, 5 palettes
\item \strong{dichromat}, 17 palettes
\item \strong{dutchmasters}, 6 palettes
\item \strong{ggpomological}, 2 palettes
\item \strong{ggsci}, 42 palettes
\item \strong{ggthemes}, 31 palettes
\item \strong{ghibli}, 27 palettes
\item \strong{grDevices}, 1 palette
\item \strong{jcolors}, 13 palettes
\item \strong{LaCroixColoR}, 21 palettes
\item \strong{NineteenEightyR}, 12 palettes
\item \strong{nord}, 16 palettes
\item \strong{ochRe}, 16 palettes
\item \strong{palettetown}, 389 palettes
\item \strong{pals}, 8 palettes
\item \strong{Polychrome}, 7 palettes
\item \strong{quickpalette}, 17 palettes
\item \strong{rcartocolor}, 34 palettes
\item \strong{RColorBrewer}, 35 palettes
\item \strong{Redmonder}, 41 palettes
\item \strong{wesanderson}, 19 palettes
\item \strong{yarrr}, 21 palettes
}
}
\section{Examples}{


Get a table of info on just the \code{"ggthemes"} color palette (easily accessible
from the \strong{paletteer} package).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_paletteer(color_pkgs = "ggthemes")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_paletteer_1.png" alt="This image of a table was generated from the first code example in the `info_paletteer()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-5
}

\seealso{
Other information functions: 
\code{\link{info_currencies}()},
\code{\link{info_date_style}()},
\code{\link{info_google_fonts}()},
\code{\link{info_locales}()},
\code{\link{info_time_style}()}
}
\concept{information functions}
