% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps_as_sf.R
\name{gps_as_sf}
\alias{gps_as_sf}
\title{Convert GPS-like data.table to a Simple Feature object}
\usage{
gps_as_sf(gps, crs = 4326)
}
\arguments{
\item{gps}{A data.table with timestamp data.}

\item{crs}{A Coordinate Reference System. The default value is 4326 (latlong WGS84).}
}
\value{
A simple feature (sf) object with point data.
}
\description{
Convert a GPS data stored in a data.table into a Simple Feature.
}
\examples{
library(dplyr)

poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))
subset <- filter_by_shape_id(poa, "T2-1") \%>\%
  filter_single_trip()

poa_gps <- gtfs2gps(subset)
poa_gps_sf <- gps_as_sf(poa_gps)
}
